#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CameraSettingsD300',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 63 => 0x69 },
	'about' => { 230 => 'about' },
	'abspeakaudiofilepath' => { 235 => 'absPeakAudioFilePath' },
	'accessorytype' => { 178 => 0x53 },
	'actionadvised' => { 74 => 0x2a },
	'activearea' => { 68 => 0xc68d },
	'actived-lighting' => { 134 => 0x22, 153 => 0x24 },
	'actived-lightingmode' => { 153 => 0x25 },
	'addaspectratioinfo' => { 45 => 0x80e },
	'additionalmodelinformation' => { 223 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 45 => 0x80f, 46 => 0x11, 47 => 0x13, 50 => 0x14 },
	'address' => { 99 => 'Address' },
	'adjustmentmode' => { 204 => [0x15,0x22] },
	'adultcontentwarning' => { 226 => 'AdultContentWarning', 229 => 'adultContentWarning' },
	'advancedraw' => { 155 => 0x76a43203 },
	'advancedscenemode' => { 178 => 0x3d },
	'advisory' => { 233 => 'Advisory' },
	'ae_iso' => { 181 => 0x2 },
	'aeaperture' => { 181 => 0x1 },
	'aebautocancel' => { 45 => 0x104 },
	'aebbracketvalue' => { 40 => 0x11 },
	'aebsequence' => { 45 => 0x105 },
	'aebsequenceautocancel' => { 43 => 0x9, 44 => 0x9, 46 => 0x8, 47 => 0x9, 50 => 0x9, 51 => 0x7 },
	'aebshotcount' => { 45 => 0x106 },
	'aebxv' => { 181 => 0x4 },
	'aeexposuretime' => { 181 => 0x0 },
	'aeextra' => { 181 => 0x7 },
	'aelbutton' => { 111 => 0x45 },
	'aelexposureindicator' => { 111 => 0x51 },
	'aelock' => { 111 => 0x5b, 143 => '733.2', 144 => '752.2', 162 => 0x201, 192 => 0x48 },
	'aelockbutton' => { 143 => '733.1', 144 => '752.1' },
	'aemaxaperture' => { 181 => 0x9 },
	'aemaxaperture2' => { 181 => 0xa },
	'aemeteringmode' => { 181 => 0xc },
	'aemeteringsegments' => { 192 => 0x209 },
	'aeminaperture' => { 181 => 0xb },
	'aeminexposuretime' => { 181 => 0x5 },
	'aeprogrammode' => { 181 => 0x6 },
	'aesetting' => { 18 => 0x21 },
	'aexv' => { 181 => 0x3 },
	'af-cpriorityselection' => { 118 => '0.1' },
	'af-onformb-d10' => { 118 => '2.1' },
	'af-spriorityselection' => { 118 => '0.2' },
	'afactivation' => { 118 => '1.1' },
	'afadjustment' => { 192 => 0x72 },
	'afaperture' => { 132 => 0x5, 133 => 0x5 },
	'afareaillumination' => { 111 => 0x4b, 144 => '763.3' },
	'afareamode' => { 111 => 0xe, 116 => 0x0, 117 => 0x5, 144 => 0x2fc, 205 => 0x11, 206 => 0x11 },
	'afareamodesetting' => { 143 => 0x2e4 },
	'afareas' => { 162 => 0x304 },
	'afassist' => { 43 => 0x5, 51 => 0x5, 111 => 0x48, 118 => '1.4', 143 => '729.2', 144 => '748.2' },
	'afassistbeam' => { 45 => 0x50e, 46 => 0x4, 47 => 0x5, 48 => 0x4, 49 => 0x4, 50 => 0x5 },
	'afassistlamp' => { 178 => 0x31 },
	'afdefocus' => { 182 => 0x6 },
	'afduringliveview' => { 45 => 0x511 },
	'affinetuneadj' => { 141 => 0x2d1, 142 => 0x2dc, 162 => 0x307 },
	'afilluminator' => { 205 => 0x29 },
	'afintegrationtime' => { 182 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 45 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 65 => 0x3009, 178 => 0xf, 204 => 0x5 },
	'afonaelockbuttonswitch' => { 45 => 0x702 },
	'afpoint' => { 18 => 0x13, 64 => 0x18, 116 => 0x1, 165 => 0x308 },
	'afpointactivationarea' => { 44 => 0x11, 50 => 0x11 },
	'afpointareaexpansion' => { 45 => 0x508 },
	'afpointautoselection' => { 45 => 0x50b },
	'afpointbrightness' => { 45 => 0x50d },
	'afpointdisplayduringfocus' => { 45 => 0x50c },
	'afpointillumination' => { 44 => 0xa, 118 => '1.3' },
	'afpointmode' => { 185 => 0x3 },
	'afpointposition' => { 65 => 0x2021, 178 => 0x4d },
	'afpointregistration' => { 43 => 0x7 },
	'afpoints' => { 110 => 0x10 },
	'afpointselected' => { 192 => 0xe },
	'afpointselected2' => { 185 => 0x4 },
	'afpointselection' => { 44 => 0xb, 118 => '0.3' },
	'afpointselectionmethod' => { 45 => 0x50f, 46 => 0xc, 47 => 0xd, 50 => 0xd },
	'afpointsinfocus' => { 40 => 0xe, 116 => 0x2, 182 => 0xb, 192 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 11 => 0x38 },
	'afpointspotmetering' => { 44 => 0xd },
	'afpointsunknown1' => { 182 => 0x0 },
	'afpointsunknown2' => { 182 => 0x2 },
	'afpointsused' => { 117 => 0x8 },
	'afpredictor' => { 182 => 0x4 },
	'afresponse' => { 134 => 0xad },
	'afresult' => { 167 => 0x1038 },
	'afsearch' => { 162 => 0x303 },
	'afwithshutter' => { 205 => 0x2a },
	'aggregationtype' => { 227 => 'aggregationType' },
	'agreement' => { 229 => 'agreement' },
	'aiservocontinuousshooting' => { 44 => 0x15 },
	'aiservoimagepriority' => { 45 => 0x503 },
	'aiservotrackingmethod' => { 45 => 0x504 },
	'aiservotrackingsensitivity' => { 44 => 0x14, 45 => 0x502 },
	'album' => { 235 => 'album' },
	'alreadyapplied' => { 218 => 'AlreadyApplied' },
	'alternatetitle' => { 227 => 'alternateTitle' },
	'alttapename' => { 235 => 'altTapeName' },
	'alttimecodetimeformat' => { 235 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 235 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 235 => 'altTimecodeValue' },
	'anti-blur' => { 207 => 0xb04b },
	'antialiasstrength' => { 68 => 0xc632 },
	'aperturerange' => { 45 => 0x10d },
	'apertureringuse' => { 185 => '1.4' },
	'aperturevalue' => { 54 => 0x2, 68 => 0x9202, 167 => 0x1002, 221 => 'ApertureValue' },
	'applekeywords' => { 171 => 'AAPL:Keywords' },
	'applicationnotes' => { 68 => 0x2bc, 180 => 0x2bc },
	'applicationrecordversion' => { 74 => 0x0 },
	'applyshootingmeteringmode' => { 45 => 0x10e },
	'approximatefnumber' => { 176 => 0x313 },
	'armidentifier' => { 75 => 0x78 },
	'armversion' => { 75 => 0x7a },
	'artfilter' => { 162 => 0x529 },
	'artist' => { 68 => 0x13b, 173 => 'Artist', 231 => 'Artist', 235 => 'artist' },
	'artworkcopyrightnotice' => { 223 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 223 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 223 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 223 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 223 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 223 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 166 => 0x1113 },
	'aspectratio' => { 166 => 0x1112, 205 => 0x55 },
	'asshoticcprofile' => { 68 => 0xc68f },
	'asshotneutral' => { 68 => 0xc628 },
	'asshotpreprofilematrix' => { 68 => 0xc690 },
	'asshotprofilename' => { 68 => 0xc6f6 },
	'asshotwhitexy' => { 68 => 0xc629 },
	'assignfuncbutton' => { 45 => 0x70b },
	'assistbuttonfunction' => { 43 => 0xd },
	'attributionname' => { 217 => 'attributionName' },
	'attributionurl' => { 217 => 'attributionURL' },
	'audio' => { 178 => 0x20 },
	'audiochanneltype' => { 235 => 'audioChannelType' },
	'audiocompression' => { 93 => 'Compression' },
	'audiocompressor' => { 235 => 'audioCompressor' },
	'audioduration' => { 74 => 0x99 },
	'audiomoddate' => { 235 => 'audioModDate' },
	'audiooutcue' => { 74 => 0x9a },
	'audiosamplerate' => { 235 => 'audioSampleRate' },
	'audiosampletype' => { 235 => 'audioSampleType' },
	'audiosamplingrate' => { 74 => 0x97 },
	'audiosamplingresolution' => { 74 => 0x98 },
	'audiotype' => { 74 => 0x96 },
	'author' => { 95 => 'Author', 171 => 'Author', 173 => 'Author', 200 => 'Author', 224 => 'Author' },
	'authorsposition' => { 225 => 'AuthorsPosition' },
	'autoaperture' => { 189 => '0.1' },
	'autobracket' => { 204 => 0x19 },
	'autobracketing' => { 72 => 0x1100, 192 => 0x18 },
	'autobracketmodem' => { 118 => '20.2' },
	'autobracketorder' => { 111 => 0x43, 118 => '20.3', 144 => '750.2' },
	'autobracketrelease' => { 134 => 0x8a },
	'autobracketset' => { 118 => '20.1', 144 => '750.1' },
	'autobrightness' => { 218 => 'AutoBrightness' },
	'autocontrast' => { 218 => 'AutoContrast' },
	'autoexposure' => { 218 => 'AutoExposure' },
	'autoexposurebracketing' => { 40 => 0x10 },
	'autofocus' => { 117 => 0x6, 165 => 0x209 },
	'autofp' => { 144 => '755.3' },
	'autoiso' => { 40 => 0x1, 65 => 0x3008, 143 => '730.1', 144 => '749.1' },
	'autoisomax' => { 143 => '730.2', 144 => '749.2' },
	'autoisominshutterspeed' => { 143 => '730.3', 144 => '749.3' },
	'autolightingoptimizer' => { 9 => 0xbe, 10 => 0xbf, 12 => 0xbf, 31 => 0x2, 45 => 0x204, 63 => 0x6f },
	'autolightingoptimizeron' => { 63 => 0x6e },
	'autoredeye' => { 155 => 0xfe28a44f },
	'autorotate' => { 40 => 0x1b },
	'autoshadows' => { 218 => 'AutoShadows' },
	'auxiliarylens' => { 134 => 0x82 },
	'avaperturesetting' => { 185 => 0x13 },
	'avsettingwithoutlens' => { 45 => 0x707 },
	'azimuth' => { 103 => 'Azimuth' },
	'babyage' => { 178 => [0x8010,0x33] },
	'baseexposurecompensation' => { 185 => 0x15 },
	'baseiso' => { 40 => 0x2, 58 => 0x101c },
	'baselineexposure' => { 68 => 0xc62a },
	'baselinenoise' => { 68 => 0xc62b },
	'baselinesharpness' => { 68 => 0xc62c },
	'baseurl' => { 233 => 'BaseURL' },
	'batteryadbodyload' => { 183 => 0x3 },
	'batteryadbodynoload' => { 183 => 0x2 },
	'batteryadgripload' => { 183 => 0x5 },
	'batteryadgripnoload' => { 183 => 0x4 },
	'batterylevel' => { 111 => 0x60 },
	'batteryorder' => { 118 => '11.3' },
	'batterystates' => { 183 => 0x1 },
	'bayergreensplit' => { 68 => 0xc62d },
	'bayerpattern' => { 78 => 0xf902, 113 => 0x17 },
	'beatspliceparamsriseindecibel' => { 235 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 235 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 235 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 235 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 118 => '12.1', 143 => '729.1', 144 => '748.1' },
	'bestqualityscale' => { 68 => 0xc65c },
	'bestshotmode' => { 65 => 0x3007 },
	'bitdepth' => { 100 => 'BitDepth', 113 => 0x11, 139 => 0x41 },
	'bitspercomponent' => { 76 => 0x87 },
	'bitspersample' => { 68 => 0x102, 231 => 'BitsPerSample' },
	'blacklevel' => { 68 => 0xc61a, 167 => 0x1012 },
	'blacklevel2' => { 166 => 0x600, 170 => 0x600 },
	'blackpoint' => { 192 => 0x200 },
	'bluebalance' => { 124 => 0x271, 167 => 0x1018, 180 => 0x12, 192 => 0x1b },
	'bluecurvelimits' => { 62 => 0x1fe },
	'bluecurvepoints' => { 62 => 0x1d4 },
	'bluehue' => { 218 => 'BlueHue' },
	'bluesaturation' => { 218 => 'BlueSaturation' },
	'blurwarning' => { 72 => 0x1300 },
	'bodyfirmwareversion' => { 163 => 0x104, 164 => 0x100, 167 => 0x104 },
	'bracketmode' => { 28 => 0x3 },
	'bracketsequence' => { 65 => 0x301d },
	'bracketshotnumber' => { 28 => 0x5, 185 => 0x9 },
	'bracketstep' => { 108 => 0xe },
	'bracketvalue' => { 28 => 0x4 },
	'brightness' => { 68 => 0xfe53, 94 => 'Brightness', 108 => 0x2c, 136 => 0x34, 205 => 0x22, 218 => 'Brightness' },
	'brightnessadj' => { 62 => 0x114, 148 => 0x0, 158 => 0x2d },
	'brightnessvalue' => { 68 => 0x9203, 167 => 0x1003, 221 => 'BrightnessValue' },
	'bulbduration' => { 40 => 0x18 },
	'burstmode' => { 81 => 0xa, 178 => 0x2a },
	'burstmode2' => { 81 => 0x18 },
	'buttonfunctioncontroloff' => { 45 => 0x70a },
	'bwfilter' => { 108 => 0x2a, 114 => 0x39 },
	'bwmode' => { 167 => 0x203 },
	'by-line' => { 74 => 0x50 },
	'by-linetitle' => { 74 => 0x55 },
	'bytecount' => { 227 => 'byteCount' },
	'calibrationilluminant1' => { 68 => 0xc65a },
	'calibrationilluminant2' => { 68 => 0xc65b },
	'cameracalibrationsig' => { 68 => 0xc6f3 },
	'cameracolorcalibration01' => { 20 => 0x4b, 21 => 0xa4, 22 => 0x85, 23 => 0xa8, 24 => 0xba },
	'cameracolorcalibration02' => { 20 => 0x4f, 21 => 0xa8, 22 => 0x89, 23 => 0xac, 24 => 0xbf },
	'cameracolorcalibration03' => { 20 => 0x53, 21 => 0xac, 22 => 0x8d, 23 => 0xb0, 24 => 0xc4 },
	'cameracolorcalibration04' => { 20 => 0x57, 21 => 0xb0, 22 => 0x91, 23 => 0xb4, 24 => 0xc9 },
	'cameracolorcalibration05' => { 20 => 0x5b, 21 => 0xb4, 22 => 0x95, 23 => 0xb8, 24 => 0xce },
	'cameracolorcalibration06' => { 20 => 0x5f, 21 => 0xb8, 22 => 0x99, 23 => 0xbc, 24 => 0xd3 },
	'cameracolorcalibration07' => { 20 => 0x63, 21 => 0xbc, 22 => 0x9d, 23 => 0xc0, 24 => 0xd8 },
	'cameracolorcalibration08' => { 20 => 0x67, 21 => 0xc0, 22 => 0xa1, 23 => 0xc4, 24 => 0xdd },
	'cameracolorcalibration09' => { 20 => 0x6b, 21 => 0xc4, 22 => 0xa5, 23 => 0xc8, 24 => 0xe2 },
	'cameracolorcalibration10' => { 20 => 0x6f, 21 => 0xc8, 22 => 0xa9, 23 => 0xcc, 24 => 0xe7 },
	'cameracolorcalibration11' => { 20 => 0x73, 21 => 0xcc, 22 => 0xad, 23 => 0xd0, 24 => 0xec },
	'cameracolorcalibration12' => { 20 => 0x77, 21 => 0xd0, 22 => 0xb1, 23 => 0xd4, 24 => 0xf1 },
	'cameracolorcalibration13' => { 20 => 0x7b, 21 => 0xd4, 22 => 0xb5, 23 => 0xd8, 24 => 0xf6 },
	'cameracolorcalibration14' => { 20 => 0x7f, 21 => 0xd8, 22 => 0xb9, 23 => 0xdc, 24 => 0xfb },
	'cameracolorcalibration15' => { 20 => 0x83, 21 => 0xdc, 22 => 0xbd, 23 => 0xe0, 24 => 0x100 },
	'cameraid' => { 167 => 0x209, 203 => 0x209 },
	'cameraiso' => { 18 => 0x10 },
	'cameraorientation' => { 2 => 0x30, 7 => 0x30, 8 => 0x30, 9 => 0x31, 10 => 0x31, 11 => 0x27, 12 => 0x31, 14 => 0x11 },
	'cameraparameters' => { 167 => 0x2050 },
	'cameraprofile' => { 218 => 'CameraProfile' },
	'cameraprofiledigest' => { 218 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 68 => 0xc62f, 214 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 162 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x18, 8 => 0x18, 9 => 0x19, 10 => 0x19, 12 => 0x19, 13 => 0x19, 15 => [0x87,0x91], 16 => [0x99,0x9f,0xa4,0xa8], 17 => [0x64,0x47,0x53,0x5b,0x5c], 176 => 0x320, 192 => 0x47 },
	'cameratype' => { 40 => 0x1a, 167 => 0x207 },
	'cameratype2' => { 163 => 0x100 },
	'canonexposuremode' => { 18 => 0x14 },
	'canonfiledescription' => { 58 => 0x805 },
	'canonfilelength' => { 32 => 0xe },
	'canonfirmwareversion' => { 32 => 0x7, 58 => 0x80b },
	'canonflashinfo' => { 58 => 0x1028 },
	'canonflashmode' => { 18 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 18 => 0xa },
	'canonimagetype' => { 32 => 0x6, 58 => 0x815 },
	'canonmodelid' => { 32 => 0x10, 58 => 0x1834 },
	'canonvrd' => { 69 => 'CanonVRD' },
	'caption-abstract' => { 74 => 0x78 },
	'captionwriter' => { 225 => 'CaptionWriter' },
	'cardshutterlock' => { 111 => 0x49 },
	'casioimagesize' => { 65 => 0x9 },
	'catalogsets' => { 213 => 'CatalogSets' },
	'categories' => { 32 => 0x23 },
	'category' => { 74 => 0xf, 225 => 'Category' },
	'ccdboardversion' => { 176 => 0x331 },
	'ccdscanmode' => { 167 => 0x1039 },
	'ccdsensitivity' => { 145 => 0x6 },
	'ccdversion' => { 176 => 0x330 },
	'celllength' => { 68 => 0x109 },
	'cellwidth' => { 68 => 0x108 },
	'centerafarea' => { 144 => '763.1' },
	'centerweightedareasize' => { 118 => '6.1', 144 => '754.3' },
	'certificate' => { 239 => 'Certificate' },
	'cfapattern' => { 68 => 0xa302 },
	'cfapatterncolumns' => { 221 => 'CFAPatternColumns' },
	'cfapatternrows' => { 221 => 'CFAPatternRows' },
	'cfapatternvalues' => { 221 => 'CFAPatternValues' },
	'channel' => { 227 => 'channel' },
	'channels' => { 93 => 'Channels' },
	'checkmark' => { 62 => 0x26a },
	'childfontfiles' => { 240 => 'FontsChildFontFiles' },
	'chromablurradius' => { 68 => 0xc631 },
	'chromaticaberration' => { 63 => 0x66 },
	'chromaticaberrationb' => { 218 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 63 => 0x6b },
	'chromaticaberrationon' => { 63 => 0x62 },
	'chromaticaberrationr' => { 218 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 63 => 0x6a },
	'chrominancenoisereduction' => { 63 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 63 => 0x60 },
	'city' => { 74 => 0x5a, 99 => 'City', 225 => 'City' },
	'clarity' => { 218 => 'Clarity' },
	'classifystate' => { 74 => 0xe1 },
	'clmodeshootingspeed' => { 118 => '9.2' },
	'cmcontrast' => { 170 => 0x2022 },
	'cmexposurecompensation' => { 170 => 0x2000 },
	'cmhue' => { 170 => 0x2021 },
	'cmsaturation' => { 170 => 0x2020 },
	'cmsharpness' => { 170 => 0x2023 },
	'cmwhitebalance' => { 170 => 0x2001 },
	'cmwhitebalancecomp' => { 170 => 0x2002 },
	'cmwhitebalancegraypoint' => { 170 => 0x2010 },
	'codec' => { 107 => 'Codec' },
	'codedcharacterset' => { 75 => 0x5a },
	'coloraberrationcontrol' => { 155 => 0xc89224b },
	'coloradjustment' => { 204 => 0x14 },
	'coloradjustmentmode' => { 203 => 0x210 },
	'coloranta' => { 240 => 'ColorantsA' },
	'colorantb' => { 240 => 'ColorantsB' },
	'colorantblack' => { 240 => 'ColorantsBlack' },
	'colorantblue' => { 240 => 'ColorantsBlue' },
	'colorantcyan' => { 240 => 'ColorantsCyan' },
	'colorantgreen' => { 240 => 'ColorantsGreen' },
	'colorantl' => { 240 => 'ColorantsL' },
	'colorantmagenta' => { 240 => 'ColorantsMagenta' },
	'colorantmode' => { 240 => 'ColorantsMode' },
	'colorantred' => { 240 => 'ColorantsRed' },
	'colorantswatchname' => { 240 => 'ColorantsSwatchName' },
	'coloranttype' => { 240 => 'ColorantsType' },
	'colorantyellow' => { 240 => 'ColorantsYellow' },
	'colorbalance' => { 94 => 'ColorBalance' },
	'colorbalanceadj' => { 155 => 0x76a43202 },
	'colorbalanceblue' => { 108 => 0x1e },
	'colorbalancegreen' => { 108 => 0x1d },
	'colorbalancered' => { 108 => 0x1c },
	'colorblur' => { 63 => 0x65 },
	'colorbooster' => { 155 => 0x5f0e7d23 },
	'colorboostlevel' => { 149 => 0x1 },
	'colorboosttype' => { 149 => 0x0 },
	'colorclass' => { 195 => 0xde },
	'colorcompensationfilter' => { 111 => [0x3a,0x5f], 112 => 0x111, 207 => 0xb022 },
	'colorcontrol' => { 167 => 0x102b },
	'colordataversion' => { 22 => 0x0, 23 => 0x0 },
	'coloreffect' => { 178 => 0x28 },
	'colorfilter' => { 64 => 0x17, 65 => 0x3017, 108 => 0x29, 114 => 0x38, 194 => 0x17 },
	'colorgain' => { 139 => 0x51 },
	'colorhue' => { 134 => 0x8d },
	'colorimetricreference' => { 68 => 0xc6bf },
	'colormatrix' => { 166 => 0x200, 167 => 0x1011 },
	'colormatrix2' => { 170 => 0x200 },
	'colormatrixa' => { 192 => 0x203 },
	'colormatrixb' => { 192 => 0x204 },
	'colormatrixnumber' => { 167 => 0x1019 },
	'colormode' => { 65 => 0x3015, 72 => 0x1210, 81 => 0x66, 108 => 0x28, 111 => 0x16, 112 => 0x101, 114 => 0x7, 134 => 0x3, 145 => 0x4, 178 => 0x32, 207 => 0xb029, 225 => 'ColorMode' },
	'colormoirereduction' => { 156 => 0x15 },
	'colormoirereductionmode' => { 156 => 0x5 },
	'colornoisereduction' => { 218 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 156 => 0x18 },
	'colornoisereductionsharpness' => { 156 => 0x1c },
	'colorplanes' => { 71 => 0x2 },
	'colorprofile' => { 108 => 0x33 },
	'colorrepresentation' => { 76 => 0x3c },
	'colorreproduction' => { 207 => 0xb020 },
	'colorsequence' => { 76 => 0x41 },
	'colorspace' => { 25 => 0x3, 32 => 0xb4, 58 => 0x10b4, 68 => 0xa001, 100 => 'ColorSpace', 109 => 0x2f, 110 => 0x25, 111 => 0x17, 134 => 0x1e, 162 => 0x507, 192 => 0x37, 204 => 0xb, 221 => 'ColorSpace' },
	'colortempasshot' => { 20 => 0x1d, 21 => 0x26, 22 => 0x43, 23 => 0x43, 24 => 0x4b },
	'colortempauto' => { 20 => 0x22, 21 => 0x1c, 22 => 0x48, 23 => 0x48, 24 => 0x50 },
	'colortempcloudy' => { 20 => 0x31, 21 => 0x35, 22 => 0x5c, 23 => 0x61, 24 => 0x69 },
	'colortempcustom' => { 22 => 0x84 },
	'colortempcustom1' => { 20 => 0x45 },
	'colortempcustom2' => { 20 => 0x4a },
	'colortempdaylight' => { 20 => 0x27, 21 => 0x2b, 22 => 0x52, 23 => 0x57, 24 => 0x5f },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 7 => 0x73, 8 => 0x73, 9 => 0x77, 10 => 0x73, 11 => 0x58, 12 => 0x73, 14 => 0x57, 32 => 0xae, 38 => 0x9, 58 => 0x10ae, 72 => 0x1005, 79 => 0x846, 94 => 'ColorTemperature', 109 => [0x6e,0x49], 110 => 0x3f, 111 => [0x39,0x5e], 112 => 0x10b, 114 => 0x3c, 176 => 0x321, 192 => 0x50, 207 => 0xb021 },
	'colortemperaturebg' => { 167 => 0x1013 },
	'colortemperaturerg' => { 167 => 0x1014 },
	'colortemperaturesetting' => { 111 => 0x25 },
	'colortempflash' => { 20 => 0x40, 21 => 0x49, 22 => 0x70, 23 => 0x75, 24 => 0x7d },
	'colortempflashdata' => { 22 => 0x24a },
	'colortempfluorescent' => { 20 => 0x3b, 21 => 0x3f, 22 => 0x66, 23 => 0x6b, 24 => 0x73 },
	'colortempkelvin' => { 21 => 0x44, 22 => 0x6b, 23 => 0x70, 24 => 0x78 },
	'colortempmeasured' => { 22 => 0x4d, 23 => 0x4d, 24 => 0x55 },
	'colortemppc1' => { 21 => 0x94, 22 => 0x75 },
	'colortemppc2' => { 21 => 0x99, 22 => 0x7a },
	'colortemppc3' => { 21 => 0x9e, 22 => 0x7f },
	'colortempshade' => { 20 => 0x2c, 21 => 0x30, 22 => 0x57, 23 => 0x5c, 24 => 0x64 },
	'colortemptungsten' => { 20 => 0x36, 21 => 0x3a, 22 => 0x61, 23 => 0x66, 24 => 0x6e },
	'colortempunknown' => { 21 => 0x21, 23 => 0x52, 24 => 0x5a },
	'colortempunknown10' => { 21 => 0x76, 23 => 0xa2, 24 => 0xaa },
	'colortempunknown11' => { 21 => 0x7b, 23 => 0xa7, 24 => 0xaf },
	'colortempunknown12' => { 21 => 0x80, 24 => 0xb4 },
	'colortempunknown13' => { 21 => 0x85, 24 => 0xb9 },
	'colortempunknown14' => { 21 => 0x8a },
	'colortempunknown15' => { 21 => 0x8f },
	'colortempunknown16' => { 21 => 0xa3 },
	'colortempunknown2' => { 21 => 0x4e, 23 => 0x7a, 24 => 0x82 },
	'colortempunknown3' => { 21 => 0x53, 23 => 0x7f, 24 => 0x87 },
	'colortempunknown4' => { 21 => 0x58, 23 => 0x84, 24 => 0x8c },
	'colortempunknown5' => { 21 => 0x5d, 23 => 0x89, 24 => 0x91 },
	'colortempunknown6' => { 21 => 0x62, 23 => 0x8e, 24 => 0x96 },
	'colortempunknown7' => { 21 => 0x67, 23 => 0x93, 24 => 0x9b },
	'colortempunknown8' => { 21 => 0x6c, 23 => 0x98, 24 => 0xa0 },
	'colortempunknown9' => { 21 => 0x71, 23 => 0x9d, 24 => 0xa5 },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 18 => 0x2a, 25 => 0x2 },
	'colortoneadj' => { 62 => 0x11e },
	'colortonefaithful' => { 11 => 0x107 },
	'colortonelandscape' => { 11 => 0x105 },
	'colortoneneutral' => { 11 => 0x106 },
	'colortoneportrait' => { 11 => 0x104 },
	'colortonestandard' => { 11 => 0x103 },
	'colortoneuserdef1' => { 11 => 0x109 },
	'colortoneuserdef2' => { 11 => 0x10a },
	'colortoneuserdef3' => { 11 => 0x10b },
	'commanddials' => { 144 => '753.1' },
	'commanddialsaperturesetting' => { 118 => '16.3' },
	'commanddialschangemainsub' => { 118 => '16.2' },
	'commanddialsmenuandplayback' => { 118 => '16.4' },
	'commanddialsreverserotation' => { 118 => '16.1' },
	'commanderchannel' => { 144 => '758.2' },
	'commandergroupa_manualoutput' => { 144 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 144 => '761.1' },
	'commandergroupamode' => { 144 => '759.2' },
	'commandergroupb_manualoutput' => { 144 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 144 => '762.1' },
	'commandergroupbmode' => { 144 => '759.3' },
	'commanderinternalflash' => { 144 => '759.1' },
	'commanderinternalmanualoutput' => { 144 => '760.2' },
	'commanderinternalttlcomp' => { 144 => '760.1' },
	'comment' => { 0 => 0x2, 69 => 'Comment', 95 => 'Comment', 173 => 'Comment' },
	'complianceprofile' => { 227 => 'complianceProfile' },
	'componentsconfiguration' => { 68 => 0x9101, 100 => 'Components', 221 => 'ComponentsConfiguration' },
	'componentversion' => { 58 => 0x80c },
	'composer' => { 235 => 'composer' },
	'compressedbitsperpixel' => { 68 => 0x9102, 221 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 112 => 0x40, 167 => 0x40 },
	'compression' => { 68 => 0x103, 231 => 'Compression' },
	'compressionfactor' => { 162 => 0x50d },
	'compressionratio' => { 100 => 'Compression', 167 => 0x1034 },
	'constrainedcropheight' => { 62 => 0x266, 195 => 0xd6 },
	'constrainedcropwidth' => { 62 => 0x262, 195 => 0xd5 },
	'contact' => { 74 => 0x76 },
	'contentlocationcode' => { 74 => 0x1a },
	'contentlocationname' => { 74 => 0x1b },
	'continuousbracketing' => { 111 => 0x20 },
	'continuousdrive' => { 18 => 0x5 },
	'continuousshootingspeed' => { 45 => 0x610 },
	'continuousshotlimit' => { 45 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 18 => 0xd, 64 => 0xc, 65 => [0x3012,0x20], 68 => [0xa408,0xfe54], 72 => [0x1004,0x1006], 94 => 'Contrast', 108 => 0x20, 109 => 0x31, 110 => 0x27, 111 => 0x19, 114 => 0x2, 136 => 0x33, 167 => 0x1029, 178 => 0x39, 192 => 0x20, 194 => 0xc, 204 => 0xd, 205 => 0x1d, 206 => 0x1a, 218 => 'Contrast', 221 => 'Contrast' },
	'contrastadj' => { 62 => 0x115, 158 => 0x2c },
	'contrastfaithful' => { 11 => 0xec },
	'contrastlandscape' => { 11 => 0xea },
	'contrastmode' => { 178 => 0x2c },
	'contrastmonochrome' => { 11 => 0xed },
	'contrastneutral' => { 11 => 0xeb },
	'contrastportrait' => { 11 => 0xe9 },
	'contrastsetting' => { 162 => 0x505, 170 => 0x1012 },
	'contraststandard' => { 11 => 0xe8 },
	'contrastuserdef1' => { 11 => 0xee },
	'contrastuserdef2' => { 11 => 0xef },
	'contrastuserdef3' => { 11 => 0xf0 },
	'contributedmediadurationscale' => { 235 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 235 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 235 => 'contributedMediaManaged' },
	'contributedmediapath' => { 235 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 235 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 235 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 235 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 235 => 'contributedMediaWebStatement' },
	'contributor' => { 219 => 'contributor' },
	'contributors' => { 95 => 'Contributors' },
	'controldialset' => { 111 => 0x46 },
	'controlledvocabularyterm' => { 223 => 'CVterm' },
	'controllerboardversion' => { 176 => 0x332 },
	'controlmode' => { 40 => 0x12 },
	'conversionlens' => { 178 => 0x35 },
	'converter' => { 68 => 0xfe4d, 145 => 0xb, 218 => 'Converter' },
	'converttograyscale' => { 218 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 68 => 0x8298, 95 => 'Copyright', 173 => 'Copyright', 200 => 'Copyright', 224 => 'Copyright', 227 => 'copyright', 229 => 'copyright', 231 => 'Copyright', 235 => 'copyright' },
	'copyrightflag' => { 198 => 0x40a },
	'copyrightnotice' => { 74 => 0x74 },
	'copyrightownerid' => { 226 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 226 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 226 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 226 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 226 => 'CopyrightStatus' },
	'coringfilter' => { 166 => 0x310, 167 => 0x102d, 170 => 0x310 },
	'coringvalues' => { 166 => 0x311, 170 => 0x311 },
	'corporateentity' => { 227 => 'corporateEntity' },
	'country' => { 99 => 'Country', 225 => 'Country' },
	'country-primarylocationcode' => { 74 => 0x64 },
	'country-primarylocationname' => { 74 => 0x65 },
	'countrycode' => { 196 => 'CountryCode', 222 => 'CountryCode' },
	'coverage' => { 219 => 'coverage' },
	'coverdate' => { 227 => 'coverDate' },
	'coverdisplaydate' => { 227 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 192 => 0x28 },
	'crc32' => { 220 => 'crc32' },
	'createdate' => { 68 => 0x9004, 95 => 'CreateDate', 171 => 'CreationDate', 200 => 'CreationDate', 233 => 'CreateDate' },
	'creationdate' => { 224 => 'CreationDate', 227 => 'creationDate' },
	'creationtime' => { 173 => 'Creation Time' },
	'creativestyle' => { 205 => 0x1a, 206 => 0x18 },
	'creator' => { 171 => 'Creator', 200 => 'Creator', 219 => 'creator', 224 => 'Creator' },
	'creatoraddress' => { 222 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 222 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 222 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 222 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 222 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 233 => 'CreatorTool' },
	'creatorworkemail' => { 222 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 222 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 222 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 74 => 0x6e, 225 => 'Credit' },
	'creditline' => { 229 => 'creditLine' },
	'creditlinereq' => { 238 => 'CreditLineReq' },
	'creditlinerequired' => { 226 => 'CreditLineRequired' },
	'cropactive' => { 62 => 0x244 },
	'cropangle' => { 218 => 'CropAngle' },
	'cropaspectratio' => { 62 => 0x260 },
	'cropbottom' => { 71 => 0x9, 150 => 0x36, 195 => 0xdc, 218 => 'CropBottom' },
	'cropheight' => { 62 => 0x24c, 166 => 0x615, 170 => 0x615, 218 => 'CropHeight' },
	'crophispeed' => { 134 => 0x1b },
	'cropleft' => { 62 => 0x246, 71 => 0x6, 150 => 0x1e, 166 => 0x612, 170 => 0x612, 195 => 0xd9, 218 => 'CropLeft' },
	'cropoutputheight' => { 150 => 0xce },
	'cropoutputheightinches' => { 150 => 0x96 },
	'cropoutputpixels' => { 150 => 0xd6 },
	'cropoutputresolution' => { 150 => 0xb6 },
	'cropoutputscale' => { 150 => 0xbe },
	'cropoutputwidth' => { 150 => 0xc6 },
	'cropoutputwidthinches' => { 150 => 0x8e },
	'cropright' => { 71 => 0x8, 150 => 0x2e, 195 => 0xdb, 218 => 'CropRight' },
	'croprotation' => { 71 => 0xb },
	'cropscaledresolution' => { 150 => 0x9e },
	'cropsourceresolution' => { 150 => 0xae },
	'croptop' => { 62 => 0x248, 71 => 0x7, 150 => 0x26, 166 => 0x613, 170 => 0x613, 195 => 0xda, 218 => 'CropTop' },
	'cropunit' => { 218 => 'CropUnit' },
	'cropunits' => { 218 => 'CropUnits' },
	'cropwidth' => { 62 => 0x24a, 166 => 0x614, 170 => 0x614, 218 => 'CropWidth' },
	'currenticcprofile' => { 68 => 0xc691 },
	'currentpreprofilematrix' => { 68 => 0xc692 },
	'curves' => { 155 => 0x76a43201 },
	'custom1' => { 226 => 'Custom1' },
	'custom10' => { 226 => 'Custom10' },
	'custom2' => { 226 => 'Custom2' },
	'custom3' => { 226 => 'Custom3' },
	'custom4' => { 226 => 'Custom4' },
	'custom5' => { 226 => 'Custom5' },
	'custom6' => { 226 => 'Custom6' },
	'custom7' => { 226 => 'Custom7' },
	'custom8' => { 226 => 'Custom8' },
	'custom9' => { 226 => 'Custom9' },
	'customcontrols' => { 45 => 0x70c },
	'customrendered' => { 68 => 0xa401, 221 => 'CustomRendered' },
	'customsaturation' => { 162 => 0x503 },
	'customwbbluelevel' => { 111 => 0x36 },
	'customwberror' => { 111 => 0x37 },
	'customwbgreenlevel' => { 111 => 0x35 },
	'customwbredlevel' => { 111 => 0x34 },
	'customwbsetting' => { 111 => 0x26 },
	'd-lightinghq' => { 155 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 151 => 0x2 },
	'd-lightinghqhighlight' => { 151 => 0x1 },
	'd-lightinghqselected' => { 155 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 151 => 0x0 },
	'd-lightinghs' => { 155 => 0xce5554aa },
	'd-lightinghsadjustment' => { 152 => 0x0 },
	'd-lightinghscolorboost' => { 152 => 0x1 },
	'datacompressionmethod' => { 76 => 0x6e },
	'dataimprint' => { 108 => 0x34 },
	'date' => { 192 => 0x6, 219 => 'date' },
	'dateacquired' => { 214 => 'DateAcquired' },
	'datecreated' => { 74 => 0x37, 225 => 'DateCreated' },
	'datedisplayformat' => { 147 => 0x3 },
	'daterecieved' => { 227 => 'dateRecieved' },
	'datesent' => { 75 => 0x46 },
	'datestampmode' => { 32 => 0x1c },
	'datetime' => { 231 => 'DateTime' },
	'datetimedigitized' => { 221 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 61 => 0x0, 68 => 0x9003, 92 => 0x14, 95 => 'OriginalDate', 221 => 'DateTimeOriginal' },
	'datetimestamp' => { 81 => 0x64 },
	'daylightsavings' => { 147 => 0x2 },
	'declination' => { 103 => 'Declination' },
	'decposition' => { 108 => 0x32 },
	'defaultcroporigin' => { 68 => 0xc61f },
	'defaultcropsize' => { 68 => 0xc620 },
	'defaultscale' => { 68 => 0xc61e },
	'defringe' => { 218 => 'Defringe' },
	'deletedimagecount' => { 134 => 0xa6, 140 => 0x6e },
	'derivedfromalternatepaths' => { 236 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 236 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 236 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 236 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 236 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 236 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 236 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 236 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 236 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 236 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 236 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 236 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 236 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 236 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 236 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 236 => 'DerivedFromVersionID' },
	'description' => { 173 => 'Description', 219 => 'description' },
	'destination' => { 75 => 0x5 },
	'destinationcity' => { 192 => 0x24 },
	'destinationcitycode' => { 194 => 0x1001 },
	'destinationdst' => { 192 => 0x26 },
	'developmentdynamicrange' => { 72 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 221 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 221 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 221 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 45 => 0x706 },
	'digitalcreationdate' => { 74 => 0x3e },
	'digitalcreationtime' => { 74 => 0x3f },
	'digitaldeehighlightadj' => { 139 => 0x202 },
	'digitaldeeshadowadj' => { 139 => 0x200 },
	'digitaldeethreshold' => { 139 => 0x201 },
	'digitalgain' => { 38 => 0xb },
	'digitalgem' => { 129 => 0x0 },
	'digitalice' => { 139 => 0x100 },
	'digitalimageguid' => { 223 => 'DigImageGUID' },
	'digitalroc' => { 138 => 0x0 },
	'digitalsourcefiletype' => { 223 => 'DigitalSourcefileType' },
	'digitalzoom' => { 18 => 0xc, 64 => 0xa, 81 => 0x68, 94 => 'DigitalZoom', 108 => 0xc, 134 => 0x86, 145 => 0xa, 167 => 0x204, 192 => 0x1e, 194 => 0xa, 203 => 0x204 },
	'digitalzoomon' => { 203 => 0x21b },
	'digitalzoomratio' => { 68 => 0xa404, 221 => 'DigitalZoomRatio' },
	'directory' => { 69 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 7 => 0x13f, 8 => 0x133, 9 => 0x1df, 10 => [0x1a3,0x1a7], 12 => [0x1a3,0x1c7], 14 => 0x1d3 },
	'directorynumber' => { 125 => 0x6 },
	'disclaimer' => { 173 => 'Disclaimer' },
	'displayallafpoints' => { 45 => 0x514 },
	'displayaperture' => { 18 => 0x23 },
	'displayedunitsx' => { 199 => 0x2 },
	'displayedunitsy' => { 199 => 0x6 },
	'distance1' => { 81 => 0x28 },
	'distance2' => { 81 => 0x2c },
	'distance3' => { 81 => 0x30 },
	'distance4' => { 81 => 0x34 },
	'distortioncorrection' => { 63 => 0x67, 162 => 0x50b },
	'distortioncorrection2' => { 166 => 0x1011 },
	'distortioncorrectionon' => { 63 => 0x63 },
	'distributor' => { 227 => 'distributor' },
	'dngbackwardversion' => { 68 => 0xc613 },
	'dnglensinfo' => { 68 => 0xc630 },
	'dngversion' => { 68 => 0xc612 },
	'document' => { 173 => 'Document' },
	'documenthistory' => { 74 => 0xe7 },
	'documentid' => { 236 => 'DocumentID' },
	'documentname' => { 68 => 0x10d },
	'documentnotes' => { 74 => 0xe6 },
	'doi' => { 227 => 'doi' },
	'dotrange' => { 68 => 0x150 },
	'drivemode' => { 108 => 0x6, 111 => 0x1e, 162 => 0x600, 192 => 0x34, 204 => 0x3, 205 => 0x4 },
	'drivemode2' => { 111 => 0xa, 185 => 0x7 },
	'dspfirmwareversion' => { 192 => 0x27 },
	'duration' => { 93 => 'Duration', 107 => 'Duration' },
	'durationscale' => { 235 => 'durationScale' },
	'durationvalue' => { 235 => 'durationValue' },
	'dynamicafarea' => { 118 => '0.4' },
	'dynamicrange' => { 72 => 0x1400 },
	'dynamicrangeexpansion' => { 192 => 0x69 },
	'dynamicrangemax' => { 62 => 0x7c },
	'dynamicrangemin' => { 62 => 0x7a },
	'dynamicrangeoptimizer' => { 111 => 0x15, 207 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 205 => 0x19, 206 => 0x17 },
	'dynamicrangeoptimizermode' => { 205 => 0x18, 206 => 0x16 },
	'dynamicrangeoptimizersetting' => { 111 => 0x27 },
	'dynamicrangesetting' => { 72 => 0x1402 },
	'e-dialinprogram' => { 185 => '1.3' },
	'easyexposurecompensation' => { 118 => '5.4' },
	'easymode' => { 18 => 0xb },
	'edgenoisereduction' => { 156 => 0x4 },
	'edition' => { 227 => 'edition' },
	'editorialupdate' => { 74 => 0x8 },
	'editstatus' => { 74 => 0x7, 196 => 'EditStatus' },
	'effectivelv' => { 192 => 0x2d },
	'effectivemaxaperture' => { 132 => 0x12, 133 => 0x13 },
	'eissn' => { 227 => 'eIssn' },
	'elevation' => { 103 => 'Elevation' },
	'email' => { 95 => 'EMail' },
	'embargodate' => { 227 => 'embargoDate', 229 => 'embargoDate' },
	'endingpage' => { 227 => 'endingPage' },
	'enduserid' => { 226 => 'EndUserEndUserID' },
	'endusername' => { 226 => 'EndUserEndUserName' },
	'engineer' => { 235 => 'engineer' },
	'enhancedarktones' => { 148 => 0x8 },
	'enhancement' => { 64 => 0x16, 65 => 0x3016 },
	'enhancer' => { 166 => 0x300 },
	'enhancervalues' => { 166 => 0x301 },
	'envelopenumber' => { 75 => 0x28 },
	'envelopepriority' => { 75 => 0x3c },
	'enveloperecordversion' => { 75 => 0x0 },
	'epsonimageheight' => { 167 => 0x20c },
	'epsonimagewidth' => { 167 => 0x20b },
	'epsonsoftware' => { 167 => 0x20d },
	'equipmentinstitution' => { 210 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 210 => 'EquipmentManufacturer' },
	'equipmentversion' => { 163 => 0x0 },
	'ettlii' => { 45 => 0x304, 46 => 0xd, 47 => 0xe, 48 => 0x7, 49 => 0x7, 50 => 0xe },
	'event' => { 213 => 'Event', 223 => 'Event', 227 => 'event' },
	'evsteps' => { 185 => '1.2', 187 => 0x0 },
	'evstepsize' => { 144 => '748.7' },
	'exclusivityenddate' => { 229 => 'exclusivityEndDate' },
	'excursiontolerance' => { 76 => 0x82 },
	'exif' => { 69 => 'EXIF' },
	'exifbyteorder' => { 69 => 'ExifByteOrder' },
	'exifcamerainfo' => { 74 => 0xe8 },
	'exifimageheight' => { 68 => 0xa003, 221 => 'PixelYDimension' },
	'exifimagewidth' => { 68 => 0xa002, 221 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 69 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 68 => 0x9000, 221 => 'ExifVersion' },
	'exitpupilposition' => { 132 => 0x4, 133 => 0x4 },
	'expirationdate' => { 74 => 0x25, 227 => 'expirationDate', 229 => 'expirationDate' },
	'expirationtime' => { 74 => 0x26 },
	'exposure' => { 68 => 0xfe51, 218 => 'Exposure' },
	'exposureadj' => { 153 => 0x0 },
	'exposureadj2' => { 153 => 0x12 },
	'exposurebracketingindicatorlast' => { 111 => 0x52 },
	'exposurebracketstepsize' => { 185 => 0x8 },
	'exposurebracketvalue' => { 134 => 0x19 },
	'exposurecompensation' => { 40 => 0x6, 54 => 0x0, 68 => 0x9204, 81 => 0x24, 94 => 'ExposureComp', 108 => 0xd, 109 => 0x53, 110 => 0x1e, 111 => 0x1, 167 => 0x1006, 192 => 0x16, 204 => [0xc,0x35], 221 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 111 => 0x47 },
	'exposurecontrolstepsize' => { 118 => '5.2' },
	'exposuredelaymode' => { 118 => '9.1', 144 => '754.4' },
	'exposuredifference' => { 134 => 0xe },
	'exposureindex' => { 68 => 0xa215, 221 => 'ExposureIndex' },
	'exposureindicator' => { 111 => 0x50 },
	'exposurelevelincrements' => { 43 => 0x6, 44 => 0x6, 45 => 0x101, 46 => 0x5, 47 => 0x6, 48 => 0x5, 49 => 0x5, 50 => 0x6, 51 => 0x4, 205 => 0x58 },
	'exposuremode' => { 68 => 0xa402, 94 => 'ExposureMode', 108 => 0x1, 109 => 0xa, 110 => 0x0, 111 => 0x0, 162 => 0x200, 204 => 0x8, 207 => 0xb041, 221 => 'ExposureMode' },
	'exposuremodeinmanual' => { 45 => 0x10b },
	'exposureprogram' => { 68 => 0x8822, 205 => 0x3c, 206 => 0x3c, 221 => 'ExposureProgram' },
	'exposureshift' => { 162 => 0x203 },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 15 => 0x6, 16 => 0x7, 40 => 0x16, 68 => 0x829a, 78 => 0xfd05, 81 => 0x20, 82 => 0xfa24, 84 => 0xf104, 87 => 0x12, 89 => 0x38, 92 => 0x10, 94 => 'ExposureTime', 108 => 0x9, 109 => 0x35, 110 => 0x48, 111 => 0x8, 192 => 0x12, 204 => 0x32, 221 => 'ExposureTime' },
	'exposuretime2' => { 204 => 0x33 },
	'exposurevalue' => { 79 => 0x3 },
	'exposurewarning' => { 72 => 0x1302 },
	'exrauto' => { 72 => 0x1033 },
	'exrmode' => { 72 => 0x1034 },
	'extendedwbdetect' => { 162 => 0x902 },
	'extender' => { 163 => 0x301 },
	'extenderfirmwareversion' => { 163 => 0x304 },
	'extendermagnification' => { 96 => 'Magnification' },
	'extendermake' => { 96 => 'Make' },
	'extendermodel' => { 96 => 'Model', 163 => 0x303 },
	'extenderserialnumber' => { 96 => 'SerialNumber', 163 => 0x302 },
	'externalflash' => { 165 => 0x1201 },
	'externalflashae1' => { 167 => 0x101f },
	'externalflashae1_0' => { 167 => 0x101b },
	'externalflashae2' => { 167 => 0x1020 },
	'externalflashae2_0' => { 167 => 0x101c },
	'externalflashbounce' => { 165 => 0x1204, 167 => 0x1026, 188 => 0x1a },
	'externalflashexposurecomp' => { 188 => 0x19 },
	'externalflashfirmware' => { 126 => 0x6, 127 => 0x6, 128 => 0x6 },
	'externalflashflags' => { 126 => 0x8, 127 => 0x8, 128 => 0x8 },
	'externalflashguidenumber' => { 165 => 0x1203, 188 => '24.1' },
	'externalflashgvalue' => { 167 => 0x1025 },
	'externalflashmode' => { 167 => 0x1028, 188 => 0x2 },
	'externalflashzoom' => { 165 => 0x1205, 167 => 0x1027 },
	'externalsensorbrightnessvalue' => { 176 => 0x311 },
	'eyestartaf' => { 111 => 0x40 },
	'face0position' => { 26 => 0x8 },
	'face1position' => { 26 => 0xa, 174 => 0x1 },
	'face2position' => { 26 => 0xc, 174 => 0x5 },
	'face3position' => { 26 => 0xe, 174 => 0x9 },
	'face4position' => { 26 => 0x10, 174 => 0xd },
	'face5position' => { 26 => 0x12, 174 => 0x11 },
	'face6position' => { 26 => 0x14 },
	'face7position' => { 26 => 0x16 },
	'face8position' => { 26 => 0x18 },
	'facedetect' => { 166 => 0x1200 },
	'facedetectarea' => { 166 => 0x1201 },
	'facedetectframeheight' => { 26 => 0x4 },
	'facedetectframewidth' => { 26 => 0x3 },
	'facepositions' => { 72 => 0x4103 },
	'facesdetected' => { 26 => 0x2, 27 => 0x2, 72 => 0x4100, 178 => 0x3f },
	'facesrecognized' => { 175 => 0x0 },
	'ffid' => { 220 => 'ffid' },
	'fieldcount' => { 167 => 0x103f },
	'filedatarate' => { 235 => 'fileDataRate' },
	'fileformat' => { 56 => 0x0, 75 => 0x14 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 7 => 0x133, 8 => 0x13f, 9 => 0x1d3, 10 => [0x197,0x19b], 12 => [0x197,0x1bb], 14 => 0x1c7 },
	'filemodifydate' => { 69 => 'FileModifyDate' },
	'filename' => { 69 => 'FileName' },
	'filenameasdelivered' => { 226 => 'FileNameAsDelivered' },
	'filenumber' => { 28 => 0x1, 32 => 0x8, 58 => 0x1817, 66 => 'FileNumber', 125 => 0x8 },
	'filenumbermemory' => { 108 => 0x1a },
	'filenumbersequence' => { 118 => '11.2' },
	'filesource' => { 68 => 0xa300, 72 => 0x8000, 221 => 'FileSource' },
	'fileversion' => { 75 => 0x16 },
	'fillflashautoreduction' => { 43 => 0xe, 44 => 0xe, 51 => 0xa },
	'filllight' => { 218 => 'FillLight' },
	'fillorder' => { 68 => 0x10a },
	'filmmode' => { 72 => 0x1401, 178 => 0x42 },
	'filmtype' => { 139 => 0x2 },
	'filtereffect' => { 28 => 0xe, 136 => 0x37 },
	'filtereffectmonochrome' => { 11 => 0xff },
	'finderdisplayduringexposure' => { 44 => 0x1 },
	'finetuneoptcenterweighted' => { 118 => '6.2' },
	'finetuneoptmatrixmetering' => { 118 => '7.1' },
	'finetuneoptspotmetering' => { 118 => '7.2' },
	'finetunestepsize' => { 118 => '5.3' },
	'firmware' => { 167 => 0x405, 204 => [0x17,0x3b], 216 => 'Firmware' },
	'firmwaredate' => { 64 => 0x15, 65 => 0x2001 },
	'firmwareid' => { 113 => 0x0 },
	'firmwarerevision' => { 11 => 0xa4, 32 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 7 => 0xff, 8 => 0x107, 79 => 0xce5, 92 => 0x57, 94 => 'FirmwareVersion', 178 => 0x2, 179 => 0x3109 },
	'firstpublicationdate' => { 226 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 74 => 0x16 },
	'flash' => { 68 => 0x9209, 109 => 0x1f, 110 => 0x15 },
	'flashactivity' => { 18 => 0x1c },
	'flashbatterylevel' => { 22 => 0x249 },
	'flashbias' => { 178 => 0x24 },
	'flashbits' => { 18 => 0x1d },
	'flashchargelevel' => { 167 => 0x1010 },
	'flashcommandermode' => { 126 => '9.1', 127 => '9.1', 128 => '9.1' },
	'flashcompensation' => { 216 => 'FlashCompensation' },
	'flashcontrolmode' => { 126 => '9.2', 127 => '9.2', 128 => '9.2', 162 => 0x404 },
	'flashdefault' => { 111 => 0x42 },
	'flashdevice' => { 167 => 0x1005 },
	'flashdistance' => { 65 => 0x2034 },
	'flashenergy' => { 68 => 0xa20b, 221 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 134 => 0x18 },
	'flashexposurecomp' => { 40 => 0xf, 72 => 0x1011, 97 => 'ExposureComp', 108 => 0x23, 111 => 0x10, 112 => 0x104, 126 => 0xa, 127 => 0xa, 128 => 0xa, 134 => 0x12, 162 => 0x401, 167 => 0x1023, 192 => 0x4d, 204 => 0x3a, 207 => 0x104 },
	'flashexposurecompset' => { 181 => 0xe },
	'flashexposureindicator' => { 111 => 0x54 },
	'flashexposureindicatorlast' => { 111 => 0x56 },
	'flashexposureindicatornext' => { 111 => 0x55 },
	'flashexposurelock' => { 28 => 0x19 },
	'flashfired' => { 81 => 0x5d, 97 => 'Fired', 108 => 0x14, 144 => '590.3', 178 => 0x8007, 221 => 'FlashFired' },
	'flashfiring' => { 45 => 0x306, 46 => 0x6, 47 => 0x7, 50 => 0x7 },
	'flashfirmwareversion' => { 163 => 0x1002 },
	'flashfocallength' => { 126 => 0xb, 127 => 0xc, 128 => 0xc },
	'flashfunction' => { 221 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 126 => 0xf, 127 => '16.1', 128 => '17.1' },
	'flashgroupaexposurecomp' => { 126 => 0x11, 127 => 0x12, 128 => 0x13 },
	'flashgroupaoutput' => { 126 => 0x11, 127 => 0x12, 128 => 0x13 },
	'flashgroupbcontrolmode' => { 126 => 0x10, 127 => '17.1', 128 => '18.1' },
	'flashgroupbexposurecomp' => { 126 => 0x12, 127 => 0x13, 128 => 0x14 },
	'flashgroupboutput' => { 126 => 0x12, 127 => 0x13, 128 => 0x14 },
	'flashgroupccontrolmode' => { 127 => '17.2', 128 => '18.2' },
	'flashgroupcexposurecomp' => { 127 => 0x14, 128 => 0x15 },
	'flashgroupcoutput' => { 127 => 0x14, 128 => 0x15 },
	'flashguidenumber' => { 40 => 0xd, 55 => 0x0, 97 => 'GuideNumber' },
	'flashintensity' => { 64 => [0x19,0x5], 162 => 0x405 },
	'flashlevel' => { 143 => 0x2e2 },
	'flashmake' => { 97 => 'Make' },
	'flashmanufacturer' => { 214 => 'FlashManufacturer' },
	'flashmetering' => { 108 => 0x3f, 111 => 0x1c },
	'flashmeteringsegments' => { 192 => 0x20a },
	'flashmode' => { 64 => 0x4, 81 => 0x5c, 97 => 'Mode', 108 => 0x2, 109 => 0x20, 110 => 0x16, 111 => 0xf, 134 => 0x87, 162 => 0x400, 167 => 0x1004, 192 => 0xc, 194 => 0x4, 201 => 0x20, 203 => 0x225, 205 => 0x23, 206 => 0x23, 221 => 'FlashMode' },
	'flashmodel' => { 97 => 'Model', 163 => 0x1001, 214 => 'FlashModel' },
	'flashoptions' => { 185 => 0x2 },
	'flashoptions2' => { 185 => 0x10 },
	'flashoutput' => { 22 => 0x248, 40 => 0x21, 126 => 0xa, 127 => 0xa, 128 => 0xa },
	'flashpixversion' => { 68 => 0xa000, 221 => 'FlashpixVersion' },
	'flashredeyemode' => { 221 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 162 => 0x403 },
	'flashreturn' => { 221 => 'FlashReturn' },
	'flashserialnumber' => { 97 => 'SerialNumber', 163 => 0x1003 },
	'flashsetting' => { 134 => 0x8 },
	'flashshutterspeed' => { 118 => '19.2', 144 => '755.2' },
	'flashstatus' => { 188 => 0x0 },
	'flashsyncspeed' => { 118 => '19.1' },
	'flashsyncspeedav' => { 43 => 0x3, 45 => 0x10f, 46 => 0x2, 47 => 0x3, 48 => 0x2, 49 => 0x2, 50 => 0x3, 51 => 0x6 },
	'flashthreshold' => { 55 => 0x1 },
	'flashtype' => { 97 => 'Type', 111 => 0x59, 134 => 0x9, 163 => 0x1000 },
	'flashwarning' => { 144 => '755.1', 178 => 0x62 },
	'flickerreduce' => { 203 => 0x218 },
	'fliphorizontal' => { 155 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 15 => 0x5, 16 => 0x6, 40 => 0x15, 68 => 0x829d, 78 => 0xfd04, 81 => 0x1e, 82 => 0xfa23, 84 => 0xf103, 87 => 0x13, 89 => 0x3c, 92 => 0xc, 101 => 'FNumber', 108 => 0xa, 109 => 0x36, 110 => 0x47, 111 => 0x9, 192 => 0x13, 204 => 0x31, 221 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1d, 8 => 0x1d, 9 => 0x1e, 10 => 0x1e, 11 => 0x28, 12 => 0x1e, 13 => 0x1e, 30 => 0x1, 65 => 0x1d, 68 => 0x920a, 87 => 0x1d, 101 => 'FocalLength', 108 => 0x12, 132 => 0xa, 133 => 0xb, 189 => 0x9, 192 => 0x1d, 221 => 'FocalLength' },
	'focallengthin35mmformat' => { 68 => 0xa405, 221 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 163 => 0x103, 167 => 0x205 },
	'focalplaneresolutionunit' => { 68 => 0xa210, 221 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 68 => 0xa20e, 221 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 30 => 0x2 },
	'focalplanexunknown' => { 30 => 0x2 },
	'focalplaneyresolution' => { 68 => 0xa20f, 221 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 30 => 0x3 },
	'focalplaneyunknown' => { 30 => 0x3 },
	'focaltype' => { 4 => 0x2d, 30 => 0x0 },
	'focalunits' => { 18 => 0x19 },
	'focus' => { 145 => 0x8 },
	'focusarea' => { 108 => 0x31 },
	'focusareaselection' => { 144 => '763.2' },
	'focuscontinuous' => { 18 => 0x20 },
	'focusdisplayaiservoandmf' => { 45 => 0x515 },
	'focusdistance' => { 101 => 'FocusDistance', 108 => 0x13, 132 => 0x9, 133 => 0xa, 165 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x45, 8 => 0x45, 9 => 0x52, 10 => 0x52, 12 => 0x52, 14 => 0x32, 40 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x43, 8 => 0x43, 9 => 0x50, 10 => 0x50, 12 => 0x50, 14 => 0x30, 40 => 0x13 },
	'focusholdbutton' => { 111 => 0x44 },
	'focusinfoversion' => { 165 => 0x0 },
	'focusingscreen' => { 44 => 0x0, 45 => 0x80b, 50 => 0x0 },
	'focusmode' => { 18 => 0x7, 64 => 0x3, 65 => [0x3003,0xd], 72 => 0x1021, 81 => 0x38, 94 => 'FocusMode', 108 => 0x30, 110 => 0xe, 111 => 0xc, 134 => 0x7, 162 => 0x301, 167 => 0x100b, 178 => 0x7, 192 => 0xd, 194 => 0x3, 205 => 0x10, 206 => 0x10 },
	'focusmode2' => { 185 => '3.1' },
	'focusmodesetting' => { 143 => 0x2e3 },
	'focusmodeswitch' => { 111 => 0x58 },
	'focuspixel' => { 72 => 0x1023 },
	'focuspointwrap' => { 118 => '1.2' },
	'focusposition' => { 132 => 0x8, 133 => 0x8, 192 => 0x10 },
	'focusprocess' => { 162 => 0x302 },
	'focusrange' => { 18 => 0x12, 167 => 0x100a },
	'focussetting' => { 204 => 0x6 },
	'focusstepcount' => { 165 => 0x301, 167 => 0x100e },
	'focusstepinfinity' => { 165 => 0x303 },
	'focusstepnear' => { 165 => 0x304 },
	'focustrackinglockon' => { 118 => '0.5' },
	'focuswarning' => { 72 => 0x1301 },
	'foldername' => { 108 => 0x27 },
	'fontcomposite' => { 240 => 'FontsComposite' },
	'fontface' => { 240 => 'FontsFontFace' },
	'fontfamily' => { 240 => 'FontsFontFamily' },
	'fontfilename' => { 240 => 'FontsFontFileName' },
	'fontname' => { 240 => 'FontsFontName' },
	'fonttype' => { 240 => 'FontsFontType' },
	'fontversion' => { 240 => 'FontsVersionString' },
	'for' => { 200 => 'For' },
	'format' => { 219 => 'format' },
	'forwardmatrix1' => { 68 => 0xc714 },
	'forwardmatrix2' => { 68 => 0xc715 },
	'framenum' => { 195 => 0xd7 },
	'framenumber' => { 72 => 0x8003, 192 => 0x29 },
	'freebytes' => { 58 => 0x1 },
	'freememorycardimages' => { 109 => [0x37,0x54], 110 => [0x2d,0x4a], 111 => 0x32 },
	'fujiflashmode' => { 72 => 0x1010 },
	'fullsizeimage' => { 100 => 'data' },
	'fullsizeimagename' => { 100 => '1Name' },
	'fullsizeimagetype' => { 100 => '0Type' },
	'functionbutton' => { 144 => '753.2' },
	'gainbase' => { 166 => 0x610 },
	'gaincontrol' => { 68 => 0xa407, 221 => 'GainControl' },
	'gamma' => { 68 => 0xa500 },
	'gammacompensatedvalue' => { 76 => 0x91 },
	'genre' => { 227 => 'genre', 235 => 'genre' },
	'geography' => { 228 => 'geography' },
	'geosync' => { 69 => 'Geosync' },
	'geotag' => { 69 => 'Geotag' },
	'geotime' => { 69 => 'Geotime' },
	'globalaltitude' => { 198 => 0x419 },
	'globalangle' => { 198 => 0x40d },
	'gpsaltitude' => { 73 => 0x6, 98 => 'Altitude', 221 => 'GPSAltitude' },
	'gpsaltituderef' => { 73 => 0x5, 221 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 73 => 0x1c, 221 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 73 => 0x1d },
	'gpsdatetime' => { 98 => 'DateTime', 221 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 73 => 0x18, 98 => 'Bearing', 221 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 73 => 0x17, 221 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 73 => 0x1a, 98 => 'Distance', 221 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 73 => 0x19, 221 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 73 => 0x14, 221 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 73 => 0x13 },
	'gpsdestlongitude' => { 73 => 0x16, 221 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 73 => 0x15 },
	'gpsdifferential' => { 73 => 0x1e, 98 => 'Differential', 221 => 'GPSDifferential' },
	'gpsdop' => { 73 => 0xb, 221 => 'GPSDOP' },
	'gpsimgdirection' => { 73 => 0x11, 221 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 73 => 0x10, 221 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 73 => 0x2, 98 => 'Latitude', 221 => 'GPSLatitude' },
	'gpslatituderef' => { 73 => 0x1 },
	'gpslongitude' => { 73 => 0x4, 98 => 'Longitude', 221 => 'GPSLongitude' },
	'gpslongituderef' => { 73 => 0x3 },
	'gpsmapdatum' => { 73 => 0x12, 98 => 'Datum', 221 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 73 => 0xa, 98 => 'MeasureMode', 221 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 73 => 0x1b, 221 => 'GPSProcessingMethod' },
	'gpssatellites' => { 73 => 0x8, 98 => 'Satellites', 221 => 'GPSSatellites' },
	'gpsspeed' => { 73 => 0xd, 98 => 'Speed', 221 => 'GPSSpeed' },
	'gpsspeedref' => { 73 => 0xc, 221 => 'GPSSpeedRef' },
	'gpsstatus' => { 73 => 0x9, 221 => 'GPSStatus' },
	'gpstimestamp' => { 73 => 0x7 },
	'gpstrack' => { 73 => 0xf, 98 => 'Heading', 221 => 'GPSTrack' },
	'gpstrackref' => { 73 => 0xe, 221 => 'GPSTrackRef' },
	'gpsversionid' => { 73 => 0x0, 221 => 'GPSVersionID' },
	'gradation' => { 162 => 0x50f },
	'graymixeraqua' => { 218 => 'GrayMixerAqua' },
	'graymixerblue' => { 218 => 'GrayMixerBlue' },
	'graymixergreen' => { 218 => 'GrayMixerGreen' },
	'graymixermagenta' => { 218 => 'GrayMixerMagenta' },
	'graymixerorange' => { 218 => 'GrayMixerOrange' },
	'graymixerpurple' => { 218 => 'GrayMixerPurple' },
	'graymixerred' => { 218 => 'GrayMixerRed' },
	'graymixeryellow' => { 218 => 'GrayMixerYellow' },
	'grayresponseunit' => { 68 => 0x122 },
	'greencurvelimits' => { 62 => 0x1c4 },
	'greencurvepoints' => { 62 => 0x19a },
	'greenhue' => { 218 => 'GreenHue' },
	'greensaturation' => { 218 => 'GreenSaturation' },
	'griddisplay' => { 118 => '12.3', 144 => '754.1' },
	'halftonehints' => { 68 => 0x141 },
	'hasalternative' => { 227 => 'hasAlternative' },
	'hascorrection' => { 227 => 'hasCorrection' },
	'hascrop' => { 218 => 'HasCrop' },
	'hasextendedxmp' => { 237 => 'HasExtendedXMP' },
	'haspreviousversion' => { 227 => 'hasPreviousVersion' },
	'hassettings' => { 218 => 'HasSettings' },
	'hastranslation' => { 227 => 'hasTranslation' },
	'headline' => { 74 => 0x69, 225 => 'Headline' },
	'hierarchicalsubject' => { 211 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 9 => 0xbb, 10 => 0xbd, 12 => 0xbd, 14 => 0xa5, 45 => 0x202, 134 => 0xb1, 192 => 0x71, 205 => 0x2c },
	'highlight' => { 204 => 0xf },
	'highlightprotection' => { 154 => 0x6 },
	'highlightrecovery' => { 218 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 10 => 0x7, 12 => 0x7, 13 => 0x7, 45 => 0x203 },
	'history' => { 225 => 'History' },
	'historyaction' => { 236 => 'HistoryAction' },
	'historychanged' => { 236 => 'HistoryChanged' },
	'historyinstanceid' => { 236 => 'HistoryInstanceID' },
	'historyparameters' => { 236 => 'HistoryParameters' },
	'historysoftwareagent' => { 236 => 'HistorySoftwareAgent' },
	'historywhen' => { 236 => 'HistoryWhen' },
	'hometowncity' => { 65 => 0x3006, 192 => 0x23 },
	'hometowncitycode' => { 194 => 0x1000 },
	'hometowndst' => { 192 => 0x25 },
	'hostcomputer' => { 68 => 0x13c },
	'hue' => { 114 => 0x3b },
	'hueadj' => { 158 => 0x2f },
	'hueadjustment' => { 109 => 0x4a, 110 => 0x40, 134 => 0x92, 136 => 0x36 },
	'hueadjustmentaqua' => { 218 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 218 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 218 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 218 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 218 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 218 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 218 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 218 => 'HueAdjustmentYellow' },
	'huesetting' => { 170 => 0x1011 },
	'icc_profile' => { 69 => 'ICC_Profile' },
	'iccprofilename' => { 225 => 'ICCProfile' },
	'identifier' => { 219 => 'identifier', 233 => 'Identifier' },
	'illumination' => { 144 => '748.5' },
	'imageadjustment' => { 134 => 0x80, 145 => 0x5 },
	'imagealterationconstraints' => { 226 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 192 => 0x38 },
	'imageauthentication' => { 134 => 0x20 },
	'imageboundary' => { 134 => 0x16 },
	'imagecount' => { 134 => 0xa5 },
	'imagecreatorid' => { 226 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 226 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 226 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 134 => 0xa2 },
	'imagedescription' => { 68 => 0x10e, 231 => 'ImageDescription' },
	'imageduplicationconstraints' => { 226 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 155 => 0xfe443a45 },
	'imagefileconstraints' => { 226 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 226 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 226 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 68 => 0x101, 113 => 0xc, 231 => 'ImageLength' },
	'imagehistory' => { 68 => 0x9213 },
	'imageidnumber' => { 176 => 0x340 },
	'imagenumber' => { 11 => 0xd0, 68 => 0x9211, 94 => 'ImageNumber', 109 => 0xae, 110 => 0x5e, 216 => 'ImageNumber' },
	'imagenumber2' => { 110 => 0x62 },
	'imageoptimization' => { 134 => 0xa9 },
	'imageorientation' => { 74 => 0x83 },
	'imageprocessing' => { 134 => 0x1a, 192 => 0x32 },
	'imageprocessingcount' => { 192 => 0x41 },
	'imageprocessingversion' => { 166 => 0x0 },
	'imagequality' => { 94 => 'ImageQuality', 144 => '708.1', 178 => 0x1 },
	'imagequality2' => { 162 => 0x603 },
	'imagereview' => { 143 => '729.4', 144 => '748.4' },
	'imagereviewtime' => { 143 => 0x2db },
	'imagesize' => { 100 => 'ImageSize' },
	'imagesizerestriction' => { 229 => 'imageSizeRestriction' },
	'imagesourcedata' => { 68 => 0x935c },
	'imagestabilization' => { 18 => 0x22, 65 => 0x3020, 94 => 'ImageStabilization', 109 => 0xbd, 110 => 0x71, 111 => 0x57, 112 => [0x18,0x107,0x113], 134 => 0xac, 165 => 0x1600, 178 => 0x1a, 205 => 0x3d, 207 => 0xb026 },
	'imagestyle' => { 205 => 0x2d },
	'imagesupplierid' => { 226 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 226 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 226 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 192 => 0x4f },
	'imagetype' => { 74 => 0x82, 226 => 'ImageType' },
	'imageuniqueid' => { 32 => 0x28, 68 => 0xa420, 221 => 'ImageUniqueID' },
	'imagewidth' => { 68 => 0x100, 113 => 0xe, 231 => 'ImageWidth' },
	'incrementaltemperature' => { 218 => 'IncrementalTemperature' },
	'incrementaltint' => { 218 => 'IncrementalTint' },
	'industry' => { 227 => 'industry', 228 => 'industry' },
	'infinitylensstep' => { 167 => 0x103b },
	'infobuttonwhenshooting' => { 45 => 0x409 },
	'ingredientsalternatepaths' => { 236 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 236 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 236 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 236 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 236 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 236 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 236 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 236 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 236 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 236 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 236 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 236 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 236 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 236 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 236 => 'IngredientsToPart' },
	'ingredientsversionid' => { 236 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 118 => '8.3' },
	'inkset' => { 68 => 0x14c },
	'instanceid' => { 236 => 'InstanceID' },
	'instantplaybacksetup' => { 111 => 0x3e },
	'instantplaybacktime' => { 111 => 0x3d },
	'instructions' => { 225 => 'Instructions' },
	'instrument' => { 235 => 'instrument' },
	'intellectualgenre' => { 222 => 'IntellectualGenre' },
	'intelligentauto' => { 207 => 0xb052 },
	'intelligentexposure' => { 178 => 0x5d },
	'interchangecolorspace' => { 76 => 0x40 },
	'internalflash' => { 108 => 0x2b, 118 => '22.1', 143 => '737.1', 144 => '756.1', 165 => 0x1208 },
	'internalflashae1' => { 167 => 0x1021 },
	'internalflashae1_0' => { 167 => 0x101d },
	'internalflashae2' => { 167 => 0x1022 },
	'internalflashae2_0' => { 167 => 0x101e },
	'internalflashmode' => { 188 => 0x1 },
	'internalflashstrength' => { 188 => 0x3 },
	'internalflashtable' => { 167 => 0x1024 },
	'internalserialnumber' => { 32 => 0x96, 39 => 0x9, 72 => 0x10, 163 => 0x102, 178 => 0x25, 184 => 0x4 },
	'interopindex' => { 68 => 0x1 },
	'interopversion' => { 68 => 0x2 },
	'intervallength' => { 108 => 0x10 },
	'intervalmode' => { 108 => 0x26 },
	'intervalnumber' => { 108 => 0x11 },
	'introtimescale' => { 235 => 'introTimeScale' },
	'introtimevalue' => { 235 => 'introTimeValue' },
	'iptc-naa' => { 68 => 0x83bb, 180 => 0x83bb },
	'iptcbitspersample' => { 76 => 0x56 },
	'iptcdigest' => { 198 => 0x425 },
	'iptcimageheight' => { 76 => 0x1e },
	'iptcimagerotation' => { 76 => 0x66 },
	'iptcimagewidth' => { 76 => 0x14 },
	'iptclastedited' => { 223 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 76 => 0xa },
	'iptcpixelheight' => { 76 => 0x32 },
	'iptcpixelwidth' => { 76 => 0x28 },
	'isbn' => { 227 => 'isbn' },
	'iscorrectionof' => { 227 => 'isCorrectionOf' },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 15 => 0x0, 16 => 0x1, 64 => 0x14, 65 => [0x3014,0x14], 68 => 0x8827, 78 => 0xfd06, 79 => 0x1784, 81 => 0x60, 82 => [0xfa2e,0xfa46], 83 => [0x27,0x28], 84 => 0xf105, 87 => 0x14, 89 => 0x4e, 92 => 0x34, 94 => 'ISO', 108 => 0x8, 130 => 0x0, 134 => 0x2, 180 => 0x17, 192 => 0x14, 194 => 0x14, 221 => 'ISOSpeedRatings' },
	'iso2' => { 130 => 0x6, 140 => 0x256, 141 => 0x25c, 142 => 0x265 },
	'isoexpansion' => { 45 => 0x103, 46 => 0x7, 47 => 0x8, 50 => 0x8, 130 => 0x4 },
	'isoexpansion2' => { 130 => 0xa },
	'isofloor' => { 185 => 0x6 },
	'isoselection' => { 134 => 0xf },
	'isosetting' => { 81 => 0x5e, 94 => 'ISOSetting', 108 => 0x24, 109 => 0x26, 110 => 0x1c, 111 => 0x13, 114 => 0x6, 134 => 0x13, 185 => '17.3', 201 => 0x27, 205 => 0x16, 206 => 0x14 },
	'isospeedexpansion' => { 44 => 0x3 },
	'isospeedincrements' => { 45 => 0x102 },
	'isospeedrange' => { 45 => 0x103 },
	'isostepsize' => { 118 => '5.1' },
	'isovalue' => { 167 => 0x1001 },
	'issn' => { 227 => 'issn' },
	'issueidentifier' => { 227 => 'issueIdentifier' },
	'issuename' => { 227 => 'issueName' },
	'istranslationof' => { 227 => 'isTranslationOf' },
	'jobid' => { 74 => 0xb8 },
	'jobrefid' => { 234 => 'JobRefId' },
	'jobrefname' => { 234 => 'JobRefName' },
	'jobrefurl' => { 234 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66 },
	'jpgfromraw' => { 58 => 0x2007, 66 => 'JpgFromRaw', 180 => 0x2e },
	'jpgfromrawlength' => { 68 => [0x117,0x202] },
	'jpgfromrawstart' => { 68 => [0x111,0x201] },
	'jpgrecordedpixels' => { 185 => 0xe },
	'key' => { 235 => 'key' },
	'keyword' => { 227 => 'keyword' },
	'keywords' => { 74 => 0x19, 95 => 'Keywords', 171 => 'Keywords', 200 => 'Keywords', 224 => 'Keywords' },
	'killdate' => { 227 => 'killDate' },
	'kodakimageheight' => { 78 => 0xf908, 81 => 0xe, 82 => [0xfa1e,0xfa52], 88 => 0x70 },
	'kodakimagewidth' => { 78 => 0xf907, 81 => 0xc, 82 => [0xfa1d,0xfa51], 88 => 0x6c },
	'kodakinfotype' => { 78 => 0xfa00 },
	'kodakmaker' => { 88 => 0x8 },
	'kodakmodel' => { 81 => 0x0, 88 => 0x28 },
	'label' => { 173 => 'Label', 233 => 'Label' },
	'language' => { 219 => 'language' },
	'languageidentifier' => { 74 => 0x87 },
	'lastfilenumber' => { 108 => 0x1b },
	'lastkeywordiptc' => { 214 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 214 => 'LastKeywordXMP' },
	'lasturl' => { 236 => 'LastURL' },
	'lc1' => { 189 => 0x2 },
	'lc10' => { 189 => 0xb },
	'lc11' => { 189 => 0xc },
	'lc12' => { 189 => 0xd },
	'lc14' => { 189 => 0xf },
	'lc15' => { 189 => 0x10 },
	'lc2' => { 189 => 0x3 },
	'lc3' => { 189 => 0x4 },
	'lc4' => { 189 => 0x5 },
	'lc5' => { 189 => 0x6 },
	'lc6' => { 189 => 0x7 },
	'lc7' => { 189 => 0x8 },
	'lcddisplayatpoweron' => { 45 => 0x811, 49 => 0xa },
	'lcddisplayreturntoshoot' => { 50 => 0x12 },
	'lcdillumination' => { 118 => '16.5' },
	'lcdilluminationduringbulb' => { 45 => 0x408 },
	'lcdpanels' => { 44 => 0x8 },
	'lcheditor' => { 155 => 0x8ae85e },
	'legacyiptcdigest' => { 225 => 'LegacyIPTCDigest' },
	'lens' => { 68 => 0xfdea, 134 => 0x84, 204 => 0xa, 216 => 'Lens' },
	'lensafstopbutton' => { 43 => 0x11, 44 => 0x13, 45 => 0x506, 46 => 0x10, 47 => 0x12, 50 => 0x13, 51 => 0x9 },
	'lensaperturerange' => { 204 => 0x30 },
	'lensdistortionparams' => { 167 => 0x206 },
	'lensdrivenoaf' => { 45 => 0x505 },
	'lensfirmwareversion' => { 163 => 0x204 },
	'lensfstops' => { 131 => 0x7, 132 => 0xc, 133 => 0xd, 134 => 0x8b, 189 => '0.3' },
	'lensid' => { 216 => 'LensID' },
	'lensidnumber' => { 131 => 0x6, 132 => 0xb, 133 => 0xc },
	'lensinfo' => { 216 => 'LensInfo' },
	'lenskind' => { 189 => 0x1 },
	'lensmake' => { 101 => 'Make' },
	'lensmanufacturer' => { 214 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 7 => 0x92b, 8 => 0x933, 32 => 0x95, 101 => 'Model', 214 => 'LensModel' },
	'lensproperties' => { 163 => 0x20b },
	'lensserialnumber' => { 101 => 'SerialNumber', 163 => 0x202, 178 => 0x52 },
	'lensshutterlock' => { 111 => 0x4a },
	'lenstemperature' => { 167 => 0x1008 },
	'lenstype' => { 2 => 0xe3, 3 => 0xd, 4 => 0xd, 5 => 0x112, 6 => 0xd, 7 => 0xd7, 8 => 0xdf, 9 => 0xf7, 10 => 0xeb, 11 => [0xd,0x98], 12 => 0xe7, 14 => 0xef, 18 => 0x16, 112 => 0x10c, 134 => 0x83, 163 => 0x201, 176 => 0x310, 178 => 0x51, 179 => 0x3405, 190 => 0x0, 191 => 0x0, 192 => 0x3f, 207 => 0xb027 },
	'levelgaugepitch' => { 162 => 0x904 },
	'levelgaugeroll' => { 162 => 0x903 },
	'license' => { 217 => 'license' },
	'licenseeid' => { 226 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 226 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 226 => 'LicenseeImageNotes' },
	'licenseename' => { 226 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 226 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 226 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 226 => 'LicenseeTransactionID' },
	'licenseid' => { 226 => 'LicenseID' },
	'licensestartdate' => { 226 => 'LicenseStartDate' },
	'licensetransactiondate' => { 226 => 'LicenseTransactionDate' },
	'licensetype' => { 220 => 'licensetype' },
	'licensorcity' => { 226 => 'LicensorLicensorCity' },
	'licensorcountry' => { 226 => 'LicensorLicensorCountry' },
	'licensoremail' => { 226 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 226 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 226 => 'LicensorLicensorID' },
	'licensorimageid' => { 226 => 'LicensorImageID' },
	'licensorname' => { 226 => 'LicensorLicensorName' },
	'licensornotes' => { 226 => 'LicensorNotes' },
	'licensorpostalcode' => { 226 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 226 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 226 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 226 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 226 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 226 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 226 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 226 => 'LicensorTransactionID' },
	'licensorurl' => { 226 => 'LicensorLicensorURL' },
	'lightcondition' => { 167 => 0x1009 },
	'lightingmode' => { 65 => 0x302a },
	'lightreading' => { 192 => 0x15 },
	'lightsource' => { 68 => 0x9208, 134 => 0x90, 170 => 0x1000, 221 => 'LightSource' },
	'lightsourcespecial' => { 203 => 0x21d },
	'lightvaluecenter' => { 167 => 0x103d },
	'lightvalueperiphery' => { 167 => 0x103e },
	'linearresponselimit' => { 68 => 0xc62e },
	'liveviewexposuresimulation' => { 45 => 0x810 },
	'liveviewshooting' => { 28 => 0x13 },
	'localafareapoint' => { 111 => 0xd, 205 => 0x12, 206 => 0x12 },
	'localcaption' => { 74 => 0x79 },
	'localizedcameramodel' => { 68 => 0xc615 },
	'location' => { 213 => 'Location', 222 => 'Location', 227 => 'location' },
	'locationcreatedcity' => { 223 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 223 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 223 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 223 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 223 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 223 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 223 => 'LocationShownCity' },
	'locationshowncountrycode' => { 223 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 223 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 223 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 223 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 223 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 45 => 0x709 },
	'logcomment' => { 235 => 'logComment' },
	'longexposurenoisereduction' => { 45 => 0x201, 46 => 0x1, 47 => 0x2, 48 => 0x1, 49 => 0x1, 50 => 0x2, 51 => 0x1, 205 => 0x2b, 207 => 0xb04e },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 7 => 0xda, 9 => 0xfa, 10 => 0xee, 11 => 0x95, 12 => 0xea, 14 => 0xf2, 18 => 0x17 },
	'loop' => { 235 => 'loop' },
	'luminanceadjustmentaqua' => { 218 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 218 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 218 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 218 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 218 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 218 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 218 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 218 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 63 => 0x5f },
	'luminancenr_tiff_jpeg' => { 63 => 0x6d },
	'luminancesmoothing' => { 218 => 'LuminanceSmoothing' },
	'm16cversion' => { 176 => 0x333 },
	'macro' => { 72 => 0x1020, 167 => 0x202, 201 => 0x21, 203 => 0x202, 207 => 0xb040 },
	'macromode' => { 18 => 0x1, 108 => 0xb, 162 => 0x300, 178 => 0x1c },
	'magnifiedview' => { 47 => 0x11, 49 => 0x9 },
	'maindialexposurecomp' => { 144 => '748.6' },
	'make' => { 59 => 0x0, 68 => 0x10f, 94 => 'Make', 173 => 'Make', 180 => 0x10f, 231 => 'Make' },
	'makernote' => { 221 => 'MakerNote' },
	'makernotecanon' => { 67 => 'MakN', 68 => 0x927c },
	'makernotecasio' => { 67 => 'MakN', 68 => 0x927c },
	'makernotecasio2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotefujifilm' => { 67 => 'MakN', 68 => 0x927c },
	'makernotehp' => { 67 => 'MakN', 68 => 0x927c },
	'makernotehp2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotehp4' => { 67 => 'MakN', 68 => 0x927c },
	'makernotehp6' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteisl' => { 67 => 'MakN', 68 => 0x927c },
	'makernotejvc' => { 67 => 'MakN', 68 => 0x927c },
	'makernotejvctext' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak10' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak1a' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak1b' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak3' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak4' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak5' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak6a' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak6b' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak7' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak8a' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak8b' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodak9' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekodakunknown' => { 67 => 'MakN', 68 => 0x927c },
	'makernotekyocera' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteleica' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteleica2' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteleica3' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteleica4' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteminolta' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteminolta2' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteminolta3' => { 67 => 'MakN', 68 => 0x927c },
	'makernotenikon' => { 67 => 'MakN', 68 => 0x927c },
	'makernotenikon2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotenikon3' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteoffset' => { 203 => 0xff },
	'makernoteolympus' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteolympus2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepanasonic' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepanasonic2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepentax' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepentax2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepentax3' => { 67 => 'MakN', 68 => 0x927c },
	'makernotepentax4' => { 67 => 'MakN', 68 => 0x927c },
	'makernotericoh' => { 67 => 'MakN', 68 => 0x927c },
	'makernotericohtext' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesafety' => { 68 => 0xc635 },
	'makernotesamsung' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesanyo' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesanyoc4' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesanyopatch' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesigma' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesony' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesony2' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesony3' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesony4' => { 67 => 'MakN', 68 => 0x927c },
	'makernotesonysrf' => { 67 => 'MakN', 68 => 0x927c },
	'makernotetype' => { 202 => 0x1 },
	'makernoteunknown' => { 67 => 'MakN', 68 => 0x927c },
	'makernoteversion' => { 112 => 0x0, 134 => 0x1, 167 => 0x0, 178 => 0x8000, 202 => 0x2, 204 => 0x1d },
	'managedfromalternatepaths' => { 236 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 236 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 236 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 236 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 236 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 236 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 236 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 236 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 236 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 236 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 236 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 236 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 236 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 236 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 236 => 'ManagedFromToPart' },
	'managedfromversionid' => { 236 => 'ManagedFromVersionID' },
	'manager' => { 236 => 'Manager' },
	'managervariant' => { 236 => 'ManagerVariant' },
	'manageto' => { 236 => 'ManageTo' },
	'manageui' => { 236 => 'ManageUI' },
	'manometerpressure' => { 162 => 0x900 },
	'manometerreading' => { 162 => 0x901 },
	'manualafpointselectpattern' => { 45 => 0x513 },
	'manualexposuretime' => { 111 => 0x6 },
	'manualflash' => { 165 => 0x1209 },
	'manualflashoutput' => { 18 => 0x29, 143 => '737.2', 144 => '756.2' },
	'manualflashstrength' => { 162 => 0x406 },
	'manualfnumber' => { 111 => 0x7 },
	'manualfocusdistance' => { 134 => 0x85, 167 => 0x100c, 203 => 0x223 },
	'manualtv' => { 44 => 0x5, 45 => 0x705 },
	'manufacturedate' => { 184 => 0x1 },
	'marked' => { 224 => 'Marked', 239 => 'Marked' },
	'markerscomment' => { 235 => 'markersComment' },
	'markerscuepointparamskey' => { 235 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 235 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 235 => 'markersCuePointType' },
	'markersduration' => { 235 => 'markersDuration' },
	'markerslocation' => { 235 => 'markersLocation' },
	'markersname' => { 235 => 'markersName' },
	'markersprobability' => { 235 => 'markersProbability' },
	'markersspeaker' => { 235 => 'markersSpeaker' },
	'markersstarttime' => { 235 => 'markersStartTime' },
	'markerstarget' => { 235 => 'markersTarget' },
	'markerstype' => { 235 => 'markersType' },
	'maskedareas' => { 68 => 0xc68e },
	'masterdocumentid' => { 74 => 0xb9 },
	'mastergain' => { 139 => 0x50 },
	'maxaperture' => { 18 => 0x1a, 84 => 0x6103, 101 => 'MaxAperture', 108 => 0x17, 189 => '14.1' },
	'maxapertureatcurrentfocal' => { 163 => 0x20a },
	'maxapertureatmaxfocal' => { 72 => 0x1407, 101 => 'MaxApertureAtMaxFocal', 131 => 0xb, 132 => 0x10, 133 => 0x11, 163 => 0x206 },
	'maxapertureatminfocal' => { 72 => 0x1406, 131 => 0xa, 132 => 0xf, 133 => 0x10, 163 => 0x205 },
	'maxaperturevalue' => { 68 => 0x9205, 221 => 'MaxApertureValue' },
	'maxavailheight' => { 223 => 'MaxAvailHeight' },
	'maxavailwidth' => { 223 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 118 => '10.1' },
	'maxfocallength' => { 72 => 0x1405, 101 => 'MaxFocalLength', 131 => 0x9, 132 => 0xe, 133 => 0xf, 163 => 0x208 },
	'maximumdensityrange' => { 76 => 0x8c },
	'maxpagesizeh' => { 240 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 240 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 240 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 68 => 0x119 },
	'mb-d10batteries' => { 118 => '11.4' },
	'mb-d80batteries' => { 144 => '754.5' },
	'mcuversion' => { 131 => 0xc, 132 => 0x11, 133 => 0x12 },
	'md5digest' => { 102 => 'zmd5' },
	'measuredev' => { 40 => 0x3, 58 => 0x1814, 94 => 'MeasuredEV' },
	'measuredev2' => { 40 => 0x17 },
	'measuredlv' => { 176 => 0x312 },
	'measuredrggb' => { 33 => 0x1 },
	'measuredrggbdata' => { 22 => 0x287 },
	'mediaconstraints' => { 226 => 'MediaConstraints' },
	'mediasummarycode' => { 226 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 43 => 0xb, 46 => 0xa, 47 => 0xb, 50 => 0xb },
	'menubuttonreturn' => { 51 => 0xb },
	'metadatadate' => { 233 => 'MetadataDate' },
	'metadatamoddate' => { 235 => 'metadataModDate' },
	'metering' => { 143 => 0x2df },
	'meteringmode' => { 18 => 0x11, 68 => 0x9207, 81 => 0x1c, 108 => 0x7, 109 => 0x25, 111 => 0x12, 162 => 0x202, 192 => 0x17, 204 => 0x9, 205 => 0x15, 206 => 0x13, 221 => 'MeteringMode' },
	'meteringmode2' => { 185 => '2.1' },
	'meteringmode3' => { 185 => '16.1' },
	'meteringoffscaleindicator' => { 111 => 0x53 },
	'meteringtime' => { 118 => '21.2', 143 => '732.2', 144 => '751.2' },
	'mieversion' => { 102 => '0Vers' },
	'minaperture' => { 18 => 0x1b, 101 => 'MinAperture', 189 => '0.2' },
	'minfocallength' => { 72 => 0x1404, 101 => 'MinFocalLength', 131 => 0x8, 132 => 0xd, 133 => 0xe, 163 => 0x207 },
	'minoltadate' => { 108 => 0x15 },
	'minoltaimagesize' => { 108 => 0x4, 109 => 0xc, 110 => 0x2, 112 => 0x103 },
	'minoltamodelid' => { 108 => 0x25 },
	'minoltaquality' => { 108 => 0x5, 109 => 0xd, 110 => 0x3, 112 => [0x102,0x103] },
	'minoltatime' => { 108 => 0x16 },
	'minormodelagedisclosure' => { 226 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 68 => 0x118 },
	'mirrorlockup' => { 43 => 0xc, 44 => 0xc, 45 => 0x60f, 46 => 0xb, 47 => 0xc, 48 => 0x6, 49 => 0x6, 50 => 0xc, 51 => 0x3 },
	'moddate' => { 224 => 'ModDate' },
	'model' => { 59 => 0x6, 68 => 0x110, 94 => 'Model', 173 => 'Model', 180 => 0x110, 231 => 'Model' },
	'modelage' => { 223 => 'ModelAge' },
	'modelingflash' => { 118 => '20.4', 144 => '755.4' },
	'modelreleaseid' => { 226 => 'ModelReleaseID' },
	'modelreleasestatus' => { 226 => 'ModelReleaseStatus' },
	'modificationdate' => { 227 => 'modificationDate' },
	'modifiedcolortemp' => { 34 => 0x9 },
	'modifieddigitalgain' => { 34 => 0xb },
	'modifiedparamflag' => { 29 => 0x1 },
	'modifiedpicturestyle' => { 34 => 0xa },
	'modifiedsaturation' => { 162 => 0x504 },
	'modifiedsensorbluelevel' => { 34 => 0x5 },
	'modifiedsensorredlevel' => { 34 => 0x4 },
	'modifiedsharpness' => { 34 => 0x2 },
	'modifiedsharpnessfreq' => { 34 => 0x3 },
	'modifiedtonecurve' => { 34 => 0x1 },
	'modifiedwhitebalance' => { 34 => 0x8 },
	'modifiedwhitebalanceblue' => { 34 => 0x7 },
	'modifiedwhitebalancered' => { 34 => 0x6 },
	'modifydate' => { 68 => 0x132, 95 => 'ModifyDate', 171 => 'ModDate', 172 => 'tIME', 200 => 'ModDate', 233 => 'ModifyDate' },
	'moirefilter' => { 68 => 0xfe58, 218 => 'MoireFilter' },
	'monitordisplayoff' => { 111 => 0x4c },
	'monitorofftime' => { 118 => '17.2', 143 => '732.1', 144 => '751.1' },
	'monochromecontrast' => { 63 => 0x3c },
	'monochromefiltereffect' => { 63 => 0x3a },
	'monochromelinear' => { 63 => 0x3d },
	'monochromesharpness' => { 63 => 0x3e },
	'monochrometoningeffect' => { 63 => 0x3b },
	'monthdaycreated' => { 81 => 0x12, 89 => 0xe },
	'morepermissions' => { 217 => 'morePermissions' },
	'multiexposureautogain' => { 135 => 0x3 },
	'multiexposuremode' => { 135 => 0x1 },
	'multiexposureshots' => { 135 => 0x2 },
	'multipleexposuremode' => { 166 => 0x101c },
	'multipleexposureset' => { 185 => '10.1' },
	'multisample' => { 139 => 0x40 },
	'multiselector' => { 118 => '8.4' },
	'multiselectorplaybackmode' => { 118 => '8.2' },
	'multiselectorshootmode' => { 118 => '8.1' },
	'mycolormode' => { 35 => 0x2 },
	'nativedigest' => { 221 => 'NativeDigest', 231 => 'NativeDigest' },
	'ncdfileinfo' => { 79 => 0x414 },
	'ndfilter' => { 40 => 0x1c },
	'nearlensstep' => { 167 => 0x103c },
	'nefcompression' => { 134 => 0x93 },
	'newsphotoversion' => { 76 => 0x0 },
	'nickname' => { 233 => 'Nickname' },
	'nikoncaptureversion' => { 134 => 0xe09 },
	'nikoniccprofile' => { 134 => 0xe1d },
	'nikonimagesize' => { 144 => 0x2c4 },
	'noisefilter' => { 162 => 0x527 },
	'noisereduction' => { 28 => 0x8, 72 => 0x100b, 109 => 0xb0, 110 => 0x60, 111 => 0x3f, 134 => 0x95, 155 => 0x753dcbc0, 156 => 0x17, 162 => 0x50a, 167 => 0x103a, 178 => 0x2d, 192 => 0x49 },
	'noisereduction2' => { 166 => 0x1010 },
	'noisereductionapplied' => { 68 => 0xc6f7 },
	'noisereductionintensity' => { 156 => 0x9 },
	'noisereductionmethod' => { 156 => 0x11 },
	'noisereductionsharpness' => { 156 => 0xd },
	'nomemorycard' => { 118 => '21.1', 143 => '729.3', 144 => '748.3' },
	'nominalmaxaperture' => { 189 => 0xa },
	'nominalminaperture' => { 189 => '10.1' },
	'notes' => { 209 => 'Notes' },
	'npages' => { 240 => 'NPages' },
	'nullrecord' => { 58 => 0x0 },
	'number' => { 227 => 'number' },
	'numberofbeats' => { 235 => 'numberOfBeats' },
	'numfacepositions' => { 174 => 0x0 },
	'numindexentries' => { 76 => 0x54 },
	'object' => { 227 => 'object' },
	'objectattributereference' => { 74 => 0x4 },
	'objectcycle' => { 74 => 0x4b },
	'objectdistance' => { 64 => 0x6, 65 => 0x2022 },
	'objectname' => { 74 => 0x5 },
	'objectpreviewdata' => { 74 => 0xca },
	'objectpreviewfileformat' => { 74 => 0xc8 },
	'objectpreviewfileversion' => { 74 => 0xc9 },
	'objecttypereference' => { 74 => 0x3 },
	'oecfcolumns' => { 221 => 'OECFColumns' },
	'oecfnames' => { 221 => 'OECFNames' },
	'oecfrows' => { 221 => 'OECFRows' },
	'oecfvalues' => { 221 => 'OECFValues' },
	'offsetschema' => { 68 => 0xea1d },
	'oldsubfiletype' => { 68 => 0xff },
	'olympusimageheight' => { 167 => 0x102f },
	'olympusimagewidth' => { 167 => 0x102e },
	'onetouchwb' => { 167 => 0x302 },
	'opticalzoom' => { 82 => 0xfa3d, 84 => [0x6006,0xf006], 85 => 0x1000, 86 => 0xf, 89 => 0x1e, 101 => 'OpticalZoom' },
	'opticalzoomcode' => { 40 => 0xa },
	'opticalzoommode' => { 178 => 0x34 },
	'opticalzoomon' => { 203 => 0x219 },
	'optionenddate' => { 229 => 'optionEndDate' },
	'ordernumber' => { 72 => 0x8002 },
	'organisationinimagecode' => { 223 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 223 => 'OrganisationInImageName' },
	'organization' => { 227 => 'organization' },
	'orientation' => { 68 => 0x112, 180 => 0x112, 231 => 'Orientation' },
	'orientationlinkedafpoint' => { 45 => 0x516 },
	'originaldecisiondata' => { 66 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 32 => 0x83 },
	'originaldocumentid' => { 236 => 'OriginalDocumentID' },
	'originalfilename' => { 58 => 0x816, 79 => 0x3e9, 90 => 0x20 },
	'originalimageheight' => { 41 => 0xc, 71 => 0x1 },
	'originalimagewidth' => { 41 => 0xb, 71 => 0x0 },
	'originalrawfiledata' => { 68 => 0xc68c },
	'originalrawfiledigest' => { 68 => 0xc71d },
	'originalrawfilename' => { 68 => 0xc68b },
	'originaltransmissionreference' => { 74 => 0x67 },
	'originatingprogram' => { 74 => 0x41 },
	'originplatform' => { 227 => 'originPlatform' },
	'os' => { 220 => 'os' },
	'otherconditions' => { 226 => 'OtherConditions' },
	'otherconstraints' => { 226 => 'OtherConstraints' },
	'otherimageinfo' => { 226 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 226 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 226 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 226 => 'OtherLicenseRequirements' },
	'outcuescale' => { 235 => 'outCueScale' },
	'outcuevalue' => { 235 => 'outCueValue' },
	'outputimageheight' => { 119 => 0x3 },
	'outputimagewidth' => { 119 => 0x2 },
	'outputresolution' => { 119 => 0x4 },
	'owner' => { 239 => 'Owner' },
	'ownerid' => { 74 => 0xbc },
	'ownername' => { 32 => 0x9, 58 => 0x810, 68 => 0xfde8, 94 => 'OwnerName', 216 => 'OwnerName' },
	'padding' => { 68 => 0xea1c },
	'pageimage' => { 233 => 'PageInfoImage' },
	'pageimageformat' => { 233 => 'PageInfoFormat' },
	'pageimageheight' => { 233 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 233 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 233 => 'PageInfoWidth' },
	'pagename' => { 68 => 0x11d },
	'pagenumber' => { 68 => 0x129 },
	'pagerange' => { 227 => 'pageRange' },
	'panasonicexifversion' => { 178 => 0x26 },
	'panasonicrawversion' => { 180 => 0x1 },
	'panasonictitle' => { 68 => 0xc6d2 },
	'panasonictitle2' => { 68 => 0xc6d3 },
	'panoramadirection' => { 36 => 0x5 },
	'panoramaframenumber' => { 36 => 0x2 },
	'panoramamode' => { 81 => 0x3c, 162 => 0x601 },
	'parametricdarks' => { 218 => 'ParametricDarks' },
	'parametrichighlights' => { 218 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 218 => 'ParametricHighlightSplit' },
	'parametriclights' => { 218 => 'ParametricLights' },
	'parametricmidtonesplit' => { 218 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 218 => 'ParametricShadows' },
	'parametricshadowsplit' => { 218 => 'ParametricShadowSplit' },
	'patientid' => { 210 => 'PatientID' },
	'patientsbirthdate' => { 210 => 'PatientDOB' },
	'patientsname' => { 210 => 'PatientName' },
	'patientssex' => { 210 => 'PatientSex' },
	'pdfversion' => { 224 => 'PDFVersion' },
	'pentaximagesize' => { 192 => 0x9 },
	'pentaxmodelid' => { 184 => 0x0, 192 => 0x5 },
	'pentaxmodeltype' => { 192 => 0x1 },
	'pentaxversion' => { 192 => 0x0 },
	'people' => { 213 => 'People' },
	'peripheralillumination' => { 63 => 0x68 },
	'peripheralilluminationon' => { 63 => 0x64 },
	'peripherallighting' => { 41 => 0x2 },
	'peripherallightingsetting' => { 42 => 0x5 },
	'peripherallightingvalue' => { 41 => 0x6 },
	'permissions' => { 229 => 'permissions' },
	'person' => { 227 => 'person' },
	'personinimage' => { 223 => 'PersonInImage' },
	'pf0customfuncregistration' => { 53 => 0x1 },
	'pf10retainprogramshift' => { 53 => 0xb },
	'pf13drivepriority' => { 53 => 0xe },
	'pf14disablefocussearch' => { 53 => 0xf },
	'pf15disableafassistbeam' => { 53 => 0x10 },
	'pf16autofocuspointshoot' => { 53 => 0x11 },
	'pf17disableafpointsel' => { 53 => 0x12 },
	'pf18enableautoafpointsel' => { 53 => 0x13 },
	'pf19continuousshootspeed' => { 53 => 0x14 },
	'pf19shootingspeedhigh' => { 52 => 0xa },
	'pf19shootingspeedlow' => { 52 => 0x9 },
	'pf1disableshootingmodes' => { 53 => 0x2 },
	'pf1value' => { 52 => 0x1 },
	'pf20limitcontinousshots' => { 53 => 0x15 },
	'pf20maxcontinousshots' => { 52 => 0xb },
	'pf21enablequietoperation' => { 53 => 0x16 },
	'pf23felocktime' => { 52 => 0xd },
	'pf23postreleasetime' => { 52 => 0xe },
	'pf23settimerlengths' => { 53 => 0x18 },
	'pf23shutterbuttontime' => { 52 => 0xc },
	'pf24lightlcdduringbulb' => { 53 => 0x19 },
	'pf25aemode' => { 52 => 0xf },
	'pf25afmode' => { 52 => 0x12 },
	'pf25afpointsel' => { 52 => 0x13 },
	'pf25colormatrix' => { 52 => 0x17 },
	'pf25defaultclearsettings' => { 53 => 0x1a },
	'pf25drivemode' => { 52 => 0x11 },
	'pf25imagesize' => { 52 => 0x14 },
	'pf25meteringmode' => { 52 => 0x10 },
	'pf25parameters' => { 52 => 0x16 },
	'pf25wbmode' => { 52 => 0x15 },
	'pf26shortenreleaselag' => { 53 => 0x1b },
	'pf27reversedialrotation' => { 53 => 0x1c },
	'pf27value' => { 52 => 0x18 },
	'pf28noquickdialexpcomp' => { 53 => 0x1d },
	'pf29quickdialswitchoff' => { 53 => 0x1e },
	'pf2disablemeteringmodes' => { 53 => 0x3 },
	'pf2value' => { 52 => 0x2 },
	'pf30enlargementmode' => { 53 => 0x1f },
	'pf31originaldecisiondata' => { 53 => 0x20 },
	'pf3manualexposuremetering' => { 53 => 0x4 },
	'pf3value' => { 52 => 0x3 },
	'pf4exposuretimelimits' => { 53 => 0x5 },
	'pf4exposuretimemax' => { 52 => 0x5 },
	'pf4exposuretimemin' => { 52 => 0x4 },
	'pf5aperturelimits' => { 53 => 0x6 },
	'pf5aperturemax' => { 52 => 0x7 },
	'pf5aperturemin' => { 52 => 0x6 },
	'pf6presetshootingmodes' => { 53 => 0x7 },
	'pf7bracketcontinuousshoot' => { 53 => 0x8 },
	'pf8bracketshots' => { 52 => 0x8 },
	'pf8setbracketshots' => { 53 => 0x9 },
	'pf9changebracketsequence' => { 53 => 0xa },
	'phonenumber' => { 95 => 'Phone' },
	'photoeffect' => { 18 => 0x28 },
	'photoeffects' => { 155 => 0xab5eca5e },
	'photoeffectsblue' => { 157 => 0x8 },
	'photoeffectsgreen' => { 157 => 0x6 },
	'photoeffectsred' => { 157 => 0x4 },
	'photoeffectstype' => { 157 => 0x0 },
	'photoinfoplayback' => { 118 => '16.6' },
	'photometricinterpretation' => { 68 => 0x106, 231 => 'PhotometricInterpretation' },
	'photoshopquality' => { 197 => 0x0 },
	'pictinfo' => { 203 => 0x208 },
	'picturecontrol' => { 155 => 0xe2173c47 },
	'picturecontrolactive' => { 158 => 0x0 },
	'picturecontroladjust' => { 136 => 0x30 },
	'picturecontrolbase' => { 136 => 0x18 },
	'picturecontrolmode' => { 158 => 0x13 },
	'picturecontrolname' => { 136 => 0x4 },
	'picturecontrolquickadjust' => { 136 => 0x31 },
	'picturefinish' => { 109 => 0x71 },
	'picturemode' => { 72 => 0x1031, 162 => 0x520, 192 => [0xb,0x33] },
	'picturemode2' => { 185 => 0x0 },
	'picturemodebwfilter' => { 162 => 0x525 },
	'picturemodecontrast' => { 162 => 0x523 },
	'picturemodehue' => { 162 => 0x522 },
	'picturemodesaturation' => { 162 => 0x521 },
	'picturemodesharpness' => { 162 => 0x524 },
	'picturemodetone' => { 162 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 9 => 0xab, 10 => 0xa7, 11 => 0x6c, 12 => 0xa7, 38 => 0xa, 63 => 0x2 },
	'planarconfiguration' => { 68 => 0x11c, 231 => 'PlanarConfiguration' },
	'platenames' => { 240 => 'PlateNames' },
	'playdisplay' => { 111 => 0x4e },
	'plusversion' => { 226 => 'Version' },
	'pngwarning' => { 173 => 'Warning' },
	'portraitrefiner' => { 65 => 0x302b },
	'postalcode' => { 99 => 'PostalCode' },
	'postcropvignetteamount' => { 218 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 218 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 218 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 218 => 'PostCropVignetteRoundness' },
	'powersource' => { 183 => 0x0 },
	'precaptureframes' => { 167 => 0x300 },
	'predictor' => { 68 => 0x13d },
	'prefs' => { 74 => 0xdd, 196 => 'Prefs' },
	'preservedfilename' => { 236 => 'PreservedFileName' },
	'presetwhitebalance' => { 111 => 0x24 },
	'previewapplicationname' => { 68 => 0xc716 },
	'previewapplicationversion' => { 68 => 0xc717 },
	'previewcolorspace' => { 68 => 0xc71a },
	'previewdatetime' => { 68 => 0xc71b },
	'previewheight' => { 82 => 0xfa58 },
	'previewimage' => { 65 => 0x2000, 66 => 'PreviewImage', 67 => 'MakN', 68 => 0x927c, 69 => 'PreviewImage', 70 => 0x4, 104 => 'data', 112 => 0x81, 167 => 0x280, 207 => 0x2001 },
	'previewimageborders' => { 192 => 0x3e },
	'previewimageheight' => { 37 => 0x4 },
	'previewimagelength' => { 37 => 0x2, 65 => 0x3, 68 => [0x117,0x202], 112 => 0x89, 137 => 0x202, 162 => 0x102, 167 => 0x1037, 192 => 0x3, 201 => 0x1e, 204 => 0x1b },
	'previewimagename' => { 104 => '1Name' },
	'previewimagesize' => { 65 => 0x2, 87 => 0x2, 104 => 'ImageSize', 192 => 0x2, 204 => 0x1c },
	'previewimagestart' => { 37 => 0x5, 65 => 0x4, 68 => [0x111,0x201], 112 => 0x88, 137 => 0x201, 162 => 0x101, 167 => 0x1036, 192 => 0x4, 201 => 0x1c, 204 => 0x1a },
	'previewimagetype' => { 104 => '0Type' },
	'previewimagevalid' => { 162 => 0x100, 167 => 0x1035 },
	'previewimagewidth' => { 37 => 0x3 },
	'previewquality' => { 37 => 0x1 },
	'previewsettingsdigest' => { 68 => 0xc719 },
	'previewsettingsname' => { 68 => 0xc718 },
	'previewwidth' => { 82 => 0xfa57 },
	'primaryafpoint' => { 117 => 0x7 },
	'primarychromaticities' => { 68 => 0x13f, 231 => 'PrimaryChromaticities' },
	'printim' => { 68 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 111 => 0x1d, 205 => 0x28 },
	'privatertkinfo' => { 211 => 'privateRTKInfo' },
	'processingsoftware' => { 68 => 0xb },
	'producer' => { 171 => 'Producer', 224 => 'Producer' },
	'productid' => { 75 => 0x32 },
	'productioncode' => { 184 => 0x2 },
	'productorserviceconstraints' => { 226 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 68 => 0xc6f4 },
	'profilecopyright' => { 68 => 0xc6fe },
	'profileembedpolicy' => { 68 => 0xc6fd },
	'profilehuesatmapdata1' => { 68 => 0xc6fa },
	'profilehuesatmapdata2' => { 68 => 0xc6fb },
	'profilehuesatmapdims' => { 68 => 0xc6f9 },
	'profilelooktabledata' => { 68 => 0xc726 },
	'profilelooktabledims' => { 68 => 0xc725 },
	'profilename' => { 68 => 0xc6f8 },
	'profiletonecurve' => { 68 => 0xc6fc },
	'programiso' => { 178 => 0x3c },
	'programline' => { 185 => '1.1' },
	'programmode' => { 114 => 0x5 },
	'programshift' => { 134 => 0xd },
	'programversion' => { 74 => 0x46 },
	'projectrefpath' => { 235 => 'projectRefPath' },
	'projectreftype' => { 235 => 'projectRefType' },
	'propertyreleaseid' => { 226 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 226 => 'PropertyReleaseStatus' },
	'province-state' => { 74 => 0x5f },
	'publicationdate' => { 227 => 'publicationDate' },
	'publicationname' => { 227 => 'publicationName' },
	'publisher' => { 219 => 'publisher' },
	'pulldown' => { 235 => 'pullDown' },
	'quality' => { 0 => 0x1, 18 => 0x3, 64 => 0x2, 65 => 0x3002, 72 => 0x1000, 81 => 0x9, 134 => 0x4, 145 => 0x3, 167 => 0x201, 176 => 0x300, 192 => 0x8, 194 => 0x2, 204 => 0x16, 205 => 0x56, 207 => [0x102,0xb047] },
	'qualitymode' => { 65 => 0x8 },
	'quantizationmethod' => { 76 => 0x78 },
	'quickadjust' => { 158 => 0x2a },
	'quickcontroldialinmeter' => { 45 => 0x703 },
	'quickshot' => { 203 => 0x213 },
	'rasterizedcaption' => { 74 => 0x7d },
	'rating' => { 68 => 0x4746, 195 => 0xdf, 220 => 'rating', 233 => 'Rating' },
	'ratingpercent' => { 68 => 0x4749, 214 => 'Rating' },
	'rawandjpgrecording' => { 43 => 0x8, 112 => 0x109, 185 => 0xd },
	'rawbrightnessadj' => { 62 => 0x38 },
	'rawcoloradj' => { 62 => 0x2e },
	'rawcolortoneadj' => { 63 => 0xd },
	'rawcontrastadj' => { 63 => 0xf },
	'rawcropbottom' => { 195 => 0xd4 },
	'rawcropleft' => { 195 => 0xd1 },
	'rawcropright' => { 195 => 0xd3 },
	'rawcroptop' => { 195 => 0xd2 },
	'rawcustomsaturation' => { 62 => 0x30 },
	'rawcustomtone' => { 62 => 0x34 },
	'rawdatauniqueid' => { 68 => 0xc65d },
	'rawdepth' => { 113 => 0x10 },
	'rawdevautogradation' => { 169 => 0x119 },
	'rawdevcolorspace' => { 168 => 0x108, 169 => 0x109 },
	'rawdevcontrastvalue' => { 168 => 0x106, 169 => 0x105 },
	'rawdeveditstatus' => { 168 => 0x10b },
	'rawdevengine' => { 168 => 0x109, 169 => 0x10b },
	'rawdevexposurebiasvalue' => { 168 => 0x100, 169 => 0x100 },
	'rawdevgradation' => { 169 => 0x112 },
	'rawdevgraypoint' => { 168 => 0x103, 169 => 0x104 },
	'rawdevmemorycoloremphasis' => { 168 => 0x105, 169 => 0x108 },
	'rawdevnoisereduction' => { 168 => 0x10a, 169 => 0x10a },
	'rawdevpicturemode' => { 169 => 0x10c },
	'rawdevpm_bwfilter' => { 169 => 0x110 },
	'rawdevpmcontrast' => { 169 => 0x10e },
	'rawdevpmnoisefilter' => { 169 => 0x120 },
	'rawdevpmpicturetone' => { 169 => 0x111 },
	'rawdevpmsaturation' => { 169 => 0x10d },
	'rawdevpmsharpness' => { 169 => 0x10f },
	'rawdevsaturation3' => { 169 => 0x113 },
	'rawdevsaturationemphasis' => { 168 => 0x104, 169 => 0x107 },
	'rawdevsettings' => { 168 => 0x10c },
	'rawdevsharpnessvalue' => { 168 => 0x107, 169 => 0x106 },
	'rawdevversion' => { 168 => 0x0, 169 => 0x0 },
	'rawdevwbfineadjustment' => { 168 => 0x102, 169 => 0x103 },
	'rawdevwhitebalance' => { 169 => 0x101 },
	'rawdevwhitebalancevalue' => { 168 => 0x101, 169 => 0x102 },
	'rawfile' => { 68 => 0xfe4c },
	'rawfilename' => { 218 => 'RawFileName' },
	'rawhighlightpoint' => { 63 => 0x12 },
	'rawimagecenter' => { 134 => 0x99 },
	'rawimagedigest' => { 68 => 0xc71c },
	'rawimagesize' => { 192 => 0x39 },
	'rawinfoversion' => { 170 => 0x0 },
	'rawjpgheight' => { 60 => 0x4 },
	'rawjpgquality' => { 28 => 0x6, 60 => 0x1 },
	'rawjpgsize' => { 28 => 0x7, 60 => 0x2 },
	'rawjpgwidth' => { 60 => 0x3 },
	'rawlinear' => { 63 => 0x10 },
	'rawmeasuredrggb' => { 21 => 0x26a, 23 => 0x280 },
	'rawsaturationadj' => { 63 => 0xe },
	'rawshadowpoint' => { 63 => 0x13 },
	'rawsharpnessadj' => { 63 => 0x11 },
	'recognizedface1age' => { 175 => 0x20 },
	'recognizedface1name' => { 175 => 0x4 },
	'recognizedface1position' => { 175 => 0x18 },
	'recognizedface2age' => { 175 => 0x50 },
	'recognizedface2name' => { 175 => 0x34 },
	'recognizedface2position' => { 175 => 0x48 },
	'recognizedface3age' => { 175 => 0x80 },
	'recognizedface3name' => { 175 => 0x64 },
	'recognizedface3position' => { 175 => 0x78 },
	'recognizedfaceflags' => { 178 => 0x63 },
	'recorddisplay' => { 111 => 0x4d },
	'recordid' => { 58 => 0x1804 },
	'recordingmode' => { 64 => 0x1, 194 => 0x1 },
	'recordmode' => { 18 => 0x9, 65 => 0x3000 },
	'recordshutterrelease' => { 203 => 0x217 },
	'redbalance' => { 124 => 0x270, 167 => 0x1017, 180 => 0x11, 192 => 0x1c },
	'redcurvelimits' => { 62 => 0x18a },
	'redcurvepoints' => { 62 => 0x160 },
	'redeyecorrection' => { 159 => 0x0 },
	'redeyeinfo' => { 218 => 'RedEyeInfo' },
	'redeyereduction' => { 111 => 0x41 },
	'redhue' => { 218 => 'RedHue' },
	'redsaturation' => { 218 => 'RedSaturation' },
	'referenceblackwhite' => { 68 => 0x214, 231 => 'ReferenceBlackWhite' },
	'referencedate' => { 74 => 0x2f },
	'referencenumber' => { 74 => 0x32 },
	'references' => { 95 => 'References' },
	'referenceservice' => { 74 => 0x2d },
	'regionconstraints' => { 226 => 'RegionConstraints' },
	'regionpersondisplayname' => { 212 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 212 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 223 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 223 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 93 => 'data' },
	'relatedaudiofilename' => { 93 => '1Name' },
	'relatedaudiofiletype' => { 93 => '0Type' },
	'relatedimagefileformat' => { 68 => 0x1000 },
	'relatedimageheight' => { 68 => 0x1002 },
	'relatedimagewidth' => { 68 => 0x1001 },
	'relatedsoundfile' => { 68 => 0xa004, 221 => 'RelatedSoundFile' },
	'relatedvideofile' => { 107 => 'data' },
	'relatedvideofilename' => { 107 => '1Name' },
	'relatedvideofiletype' => { 107 => '0Type' },
	'relation' => { 219 => 'relation' },
	'relativepeakaudiofilepath' => { 235 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 235 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 235 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 118 => '16.8' },
	'releasedate' => { 74 => 0x1e, 235 => 'releaseDate' },
	'releasesetting' => { 58 => 0x1016 },
	'releasetime' => { 74 => 0x23 },
	'remoteonduration' => { 143 => '732.4', 144 => '752.3' },
	'renditionclass' => { 236 => 'RenditionClass' },
	'renditionofalternatepaths' => { 236 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 236 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 236 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 236 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 236 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 236 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 236 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 236 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 236 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 236 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 236 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 236 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 236 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 236 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 236 => 'RenditionOfToPart' },
	'renditionofversionid' => { 236 => 'RenditionOfVersionID' },
	'renditionparams' => { 236 => 'RenditionParams' },
	'repeatingflashcount' => { 126 => 0xd, 127 => 0xe, 128 => 0xe, 144 => '757.2' },
	'repeatingflashoutput' => { 144 => '757.1' },
	'repeatingflashrate' => { 126 => 0xc, 127 => 0xd, 128 => 0xd, 144 => '758.1' },
	'resampleparamsquality' => { 235 => 'resampleParamsQuality' },
	'resaved' => { 203 => 0x21e },
	'resolution' => { 100 => 'Resolution' },
	'resolutionmode' => { 204 => 0x4 },
	'resolutionunit' => { 68 => 0x128, 77 => 0x2, 231 => 'ResolutionUnit' },
	'restrictions' => { 229 => 'restrictions' },
	'retouchhistory' => { 134 => 0x9e },
	'retouchinfo' => { 218 => 'RetouchInfo' },
	'reuse' => { 226 => 'Reuse' },
	'reuseallowed' => { 238 => 'ReuseAllowed' },
	'reuseprohibited' => { 229 => 'reuseProhibited' },
	'reverseindicators' => { 118 => '11.1' },
	'revision' => { 220 => 'revision' },
	'rgbcurvelimits' => { 62 => 0x238 },
	'rgbcurvepoints' => { 62 => 0x20e },
	'ricohdate' => { 201 => 0x6 },
	'ricohimageheight' => { 201 => 0x2 },
	'ricohimagewidth' => { 201 => 0x0 },
	'rightascension' => { 103 => 'RightAscension' },
	'rights' => { 219 => 'rights' },
	'rightsagent' => { 227 => 'rightsAgent', 229 => 'rightsAgent' },
	'rightsowner' => { 229 => 'rightsOwner' },
	'romoperationmode' => { 58 => 0x80d },
	'rotation' => { 15 => 0x17, 16 => 0x18, 57 => 0x3, 62 => 0x26e, 71 => 0x4, 103 => 'Rotation', 109 => [0x65,0x50], 110 => 0x46, 111 => 0x5a, 144 => '590.1', 155 => 0x76a43207, 178 => 0x30, 185 => '17.2', 195 => 0xd8, 205 => 0x3f, 206 => 0x3f },
	'routing' => { 200 => 'Routing' },
	'rowsperstrip' => { 68 => 0x116 },
	'rpp' => { 215 => 'rpp' },
	'safetyshift' => { 45 => 0x108 },
	'safetyshiftinavortv' => { 43 => 0x10, 44 => 0x10, 46 => 0xf, 47 => 0x10, 50 => 0x10 },
	'samplebits' => { 93 => 'SampleBits' },
	'samplerate' => { 93 => 'SampleRate' },
	'samplesperpixel' => { 68 => 0x115, 231 => 'SamplesPerPixel' },
	'samplestructure' => { 76 => 0x5a },
	'sanyoquality' => { 203 => 0x201 },
	'sanyothumbnail' => { 203 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 18 => 0xe, 25 => 0x1, 64 => 0xd, 65 => [0x3013,0x1f], 68 => [0xa409,0xfe55], 72 => 0x1003, 94 => 'Saturation', 108 => 0x1f, 109 => 0x32, 110 => 0x28, 111 => 0x1a, 114 => 0x1, 134 => [0x94,0xaa], 136 => 0x35, 178 => 0x40, 192 => 0x1f, 194 => 0xd, 201 => 0x28, 204 => 0x10, 205 => 0x1e, 206 => 0x1b, 218 => 'Saturation', 221 => 'Saturation' },
	'saturationadj' => { 62 => 0x116, 154 => 0x1, 158 => 0x2e },
	'saturationadjustmentaqua' => { 218 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 218 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 218 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 218 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 218 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 218 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 218 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 218 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 11 => 0xfe },
	'saturationlandscape' => { 11 => 0xfc },
	'saturationneutral' => { 11 => 0xfd },
	'saturationportrait' => { 11 => 0xfb },
	'saturationsetting' => { 170 => 0x1010 },
	'saturationstandard' => { 11 => 0xfa },
	'saturationuserdef1' => { 11 => 0x100 },
	'saturationuserdef2' => { 11 => 0x101 },
	'saturationuserdef3' => { 11 => 0x102 },
	'saveid' => { 236 => 'SaveID' },
	'scaletype' => { 235 => 'scaleType' },
	'scanimageenhancer' => { 139 => 0x60 },
	'scanningdirection' => { 76 => 0x64 },
	'scene' => { 222 => 'Scene', 235 => 'scene' },
	'scenearea' => { 165 => 0x211, 167 => 0x1031 },
	'sceneassist' => { 134 => 0x9c },
	'scenecapturetype' => { 68 => 0xa406, 221 => 'SceneCaptureType' },
	'scenedetect' => { 165 => 0x210, 167 => 0x1030 },
	'scenedetectdata' => { 165 => 0x212, 167 => 0x1033 },
	'scenemode' => { 82 => 0xfa02, 112 => 0x100, 134 => 0x8f, 162 => 0x509, 167 => 0x403, 178 => 0x8001, 207 => 0xb023 },
	'scenemodeused' => { 84 => [0x6002,0xf002] },
	'sceneselect' => { 203 => 0x21f },
	'scenetype' => { 68 => 0xa301, 221 => 'SceneType' },
	'section' => { 227 => 'section' },
	'securityclassification' => { 68 => 0x9212 },
	'selectableafpoint' => { 45 => 0x509 },
	'selectafareaselectmode' => { 45 => 0x512 },
	'selftimer' => { 18 => 0x2, 65 => 0x3001, 178 => 0x2e, 203 => 0x214 },
	'selftimer2' => { 40 => 0x1d },
	'selftimermode' => { 68 => 0x882b },
	'selftimertime' => { 58 => 0x1806, 111 => 0x1f, 118 => '17.1', 143 => '732.3', 144 => '751.3' },
	'seminfo' => { 68 => 0x8546 },
	'sensingmethod' => { 68 => 0xa217, 221 => 'SensingMethod' },
	'sensitivityadjust' => { 192 => 0x40 },
	'sensitivitysteps' => { 185 => '17.4', 187 => 0x1 },
	'sensorbluelevel' => { 38 => 0x5 },
	'sensorcleaning' => { 51 => 0xd },
	'sensorfullheight' => { 78 => 0xf904 },
	'sensorfullwidth' => { 78 => 0xf903 },
	'sensorheight' => { 78 => 0xf901, 82 => 0xfa21, 113 => 0x8, 179 => 0x312c },
	'sensorpixelsize' => { 134 => 0x9a },
	'sensorredlevel' => { 38 => 0x4 },
	'sensorsize' => { 94 => 'SensorSize' },
	'sensortemperature' => { 165 => 0x1500, 167 => 0x1007 },
	'sensorwidth' => { 78 => 0xf900, 82 => 0xfa20, 113 => 0xa, 179 => 0x312b },
	'sequencenumber' => { 40 => 0x9, 65 => 0x301c, 72 => 0x1101, 81 => 0x1d, 178 => 0x2b },
	'sequenceshotinterval' => { 203 => 0x224 },
	'sequentialshot' => { 203 => 0x20e },
	'serialnumber' => { 32 => 0xc, 58 => 0x180b, 68 => 0xfde9, 78 => 0xfa04, 80 => 0xfa00, 82 => 0xfa19, 91 => 0x0, 92 => 0xa8, 94 => 'SerialNumber', 134 => 0xa0, 163 => 0x101, 167 => [0x404,0x101a], 176 => 0x303, 204 => 0x2, 216 => 'SerialNumber' },
	'serialnumberformat' => { 32 => 0x15, 58 => 0x183b },
	'seriesdatetime' => { 210 => 'SeriesDateTime' },
	'seriesdescription' => { 210 => 'SeriesDescription' },
	'seriesmodality' => { 210 => 'SeriesModality' },
	'seriesnumber' => { 210 => 'SeriesNumber' },
	'serviceidentifier' => { 75 => 0x1e },
	'setbuttoncrosskeysfunc' => { 48 => 0x0, 49 => 0x0 },
	'setbuttonwhenshooting' => { 43 => 0x1, 45 => 0x704, 51 => 0xc },
	'setfunctionwhenshooting' => { 46 => 0x0, 47 => 0x1, 50 => 0x1 },
	'shadingcompensation' => { 162 => 0x50c },
	'shadingcompensation2' => { 166 => 0x1012 },
	'shadow' => { 204 => 0xe },
	'shadowprotection' => { 154 => 0x0 },
	'shadows' => { 68 => 0xfe52, 218 => 'Shadows' },
	'shadowscale' => { 68 => 0xc633 },
	'shadowtint' => { 218 => 'ShadowTint' },
	'shakereduction' => { 193 => 0x1 },
	'sharpendetail' => { 218 => 'SharpenDetail' },
	'sharpenedgemasking' => { 218 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 158 => 0x2b },
	'sharpenradius' => { 218 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 18 => 0xf, 38 => 0x2, 64 => 0xb, 65 => [0x3011,0x21], 68 => [0xa40a,0xfe56], 72 => 0x1001, 81 => 0x6b, 89 => 0x37, 94 => 'Sharpness', 108 => 0x21, 109 => 0x30, 110 => 0x26, 111 => 0x18, 114 => 0x3, 134 => 0x6, 136 => 0x32, 167 => 0x100f, 178 => 0x41, 192 => 0x21, 194 => 0xb, 201 => 0x22, 202 => 0x1003, 204 => 0x11, 205 => 0x1c, 206 => 0x19, 218 => 'Sharpness', 221 => 'Sharpness' },
	'sharpnessadj' => { 62 => 0x25a },
	'sharpnessfactor' => { 167 => 0x102a },
	'sharpnessfaithful' => { 11 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 38 => 0x3 },
	'sharpnesslandscape' => { 11 => 0xf3 },
	'sharpnessmonochrome' => { 11 => 0xf6 },
	'sharpnessneutral' => { 11 => 0xf4 },
	'sharpnessportrait' => { 11 => 0xf2 },
	'sharpnesssetting' => { 162 => 0x506, 170 => 0x1013 },
	'sharpnessstandard' => { 11 => 0xf1 },
	'sharpnessuserdef1' => { 11 => 0xf7 },
	'sharpnessuserdef2' => { 11 => 0xf8 },
	'sharpnessuserdef3' => { 11 => 0xf9 },
	'shootinginfodisplay' => { 118 => '12.2' },
	'shootingmode' => { 94 => 'ShootingMode', 134 => 0x89, 178 => 0x1f },
	'shootingmodesetting' => { 143 => '734.1' },
	'shortdescription' => { 220 => 'shortdescription' },
	'shortdocumentid' => { 74 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 7 => 0xd8, 9 => 0xf8, 10 => 0xec, 11 => 0x93, 12 => 0xe8, 14 => 0xf0, 18 => 0x18 },
	'shortownername' => { 11 => 0xac },
	'shortreleasetimelag' => { 45 => 0x80d },
	'shotdate' => { 235 => 'shotDate' },
	'shotlocation' => { 235 => 'shotLocation' },
	'shotname' => { 235 => 'shotName' },
	'shutter-aelock' => { 43 => 0x4, 45 => 0x701, 46 => 0x3, 47 => 0x4, 48 => 0x3, 49 => 0x3, 50 => 0x4, 51 => 0x2 },
	'shutteraelbutton' => { 44 => 0x4 },
	'shutterbuttonafonbutton' => { 45 => 0x701 },
	'shuttercount' => { 5 => 0x176, 28 => 0x1, 140 => [0x6a,0x157,0x276], 141 => 0x279, 142 => 0x284, 143 => 0x246, 144 => 0x24a, 192 => 0x5d },
	'shuttercurtainsync' => { 43 => 0xf, 44 => 0xf, 45 => 0x305, 46 => 0xe, 47 => 0xf, 48 => 0x8, 49 => 0x8, 50 => 0xf, 51 => 0x8 },
	'shuttermode' => { 81 => 0x1b },
	'shutterreleasebuttonae-l' => { 118 => '16.7' },
	'shutterreleasemethod' => { 58 => 0x1010 },
	'shutterreleasenocfcard' => { 43 => 0x2, 44 => 0x2, 51 => 0xf },
	'shutterreleasetiming' => { 58 => 0x1011 },
	'shutterspeedrange' => { 45 => 0x10c },
	'shutterspeedvalue' => { 54 => 0x1, 68 => 0x9201, 167 => 0x1000, 221 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 225 => 'SidecarForExtension' },
	'similarityindex' => { 74 => 0xe4 },
	'singleframebracketing' => { 111 => 0x21 },
	'slaveflashmeteringsegments' => { 192 => 0x20b },
	'slowshutter' => { 40 => 0x8 },
	'slowsync' => { 72 => 0x1030 },
	'smoothness' => { 68 => 0xfe57, 218 => 'Smoothness' },
	'software' => { 68 => 0x131, 95 => 'Software', 173 => 'Software', 204 => 0x18, 231 => 'Software' },
	'softwareversion' => { 203 => 0x207 },
	'sonydatetime' => { 208 => 0x6 },
	'sonyimagesize' => { 111 => 0x3b, 205 => 0x54, 206 => 0x54 },
	'sonyquality' => { 111 => 0x3c },
	'source' => { 74 => 0x73, 173 => 'Source', 219 => 'source', 220 => 'source', 225 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 221 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 221 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 221 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 221 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 235 => 'speakerPlacement' },
	'specialeffectlevel' => { 65 => 0x3030 },
	'specialeffectmode' => { 65 => 0x2076 },
	'specialeffectsetting' => { 65 => 0x3031 },
	'specialinstructions' => { 74 => 0x28 },
	'specialmode' => { 167 => 0x200, 203 => 0x200 },
	'spectralsensitivity' => { 68 => 0x8824, 221 => 'SpectralSensitivity' },
	'splittoningbalance' => { 218 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 218 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 218 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 218 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 218 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 108 => 0x2d },
	'spotfocuspointy' => { 108 => 0x2e },
	'spotmeteringmode' => { 18 => 0x27 },
	'spotmeterlinktoafpoint' => { 45 => 0x107 },
	'sractive' => { 185 => '17.1' },
	'srawquality' => { 18 => 0x2e },
	'srfocallength' => { 193 => 0x3 },
	'srhalfpresstime' => { 193 => 0x2 },
	'srresult' => { 193 => 0x0 },
	'startingpage' => { 227 => 'startingPage' },
	'starttimecodetimeformat' => { 235 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 235 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 235 => 'startTimecodeValue' },
	'state' => { 99 => 'State', 225 => 'State' },
	'status' => { 213 => 'Status' },
	'storagemethod' => { 113 => 0x12 },
	'straightenangle' => { 155 => 0x2fc08431 },
	'stretchmode' => { 235 => 'stretchMode' },
	'studydatetime' => { 210 => 'StudyDateTime' },
	'studydescription' => { 210 => 'StudyDescription' },
	'studyid' => { 210 => 'StudyID' },
	'studyphysician' => { 210 => 'StudyPhysician' },
	'sub-location' => { 74 => 0x5c },
	'subfiledata' => { 102 => 'data' },
	'subfiledirectory' => { 102 => '1Directory' },
	'subfilemimetype' => { 102 => '2MIME' },
	'subfilename' => { 102 => '1Name' },
	'subfileresource' => { 102 => 'rsrc' },
	'subfiletype' => { 68 => 0xfe, 102 => '0Type' },
	'subject' => { 171 => 'Subject', 200 => 'Subject', 219 => 'subject', 224 => 'Subject' },
	'subjectarea' => { 68 => 0x9214, 221 => 'SubjectArea' },
	'subjectcode' => { 222 => 'SubjectCode' },
	'subjectdistance' => { 68 => 0x9206, 81 => 0x3e, 221 => 'SubjectDistance' },
	'subjectdistancerange' => { 68 => 0xa40c, 221 => 'SubjectDistanceRange' },
	'subjectlocation' => { 68 => 0xa214, 221 => 'SubjectLocation' },
	'subjectprogram' => { 108 => 0x22 },
	'subjectreference' => { 74 => 0xc },
	'subsectime' => { 68 => 0x9290 },
	'subsectimedigitized' => { 68 => 0x9292 },
	'subsectimeoriginal' => { 68 => 0x9291 },
	'subsection1' => { 227 => 'subsection1' },
	'subsection2' => { 227 => 'subsection2' },
	'subsection3' => { 227 => 'subsection3' },
	'subsection4' => { 227 => 'subsection4' },
	'superimposeddisplay' => { 43 => 0xa, 45 => 0x510, 46 => 0x9, 47 => 0xa, 50 => 0xa, 51 => 0xe },
	'supermacro' => { 32 => 0x1a },
	'supplementalcategories' => { 74 => 0x14, 225 => 'SupplementalCategories' },
	'supplementaltype' => { 76 => 0x37 },
	'svisosetting' => { 185 => 0x14 },
	'switchtoregisteredafpoint' => { 44 => 0x12, 45 => 0x50a },
	'tagged' => { 195 => 0xdd },
	'tapename' => { 235 => 'tapeName' },
	'targetaperture' => { 40 => 0x4 },
	'targetcompressionratio' => { 56 => 0x1 },
	'targetdistancesetting' => { 58 => 0x1807 },
	'targetexposuretime' => { 40 => 0x5 },
	'targetimagetype' => { 58 => 0x100a },
	'teaser' => { 227 => 'teaser' },
	'teleconverter' => { 112 => 0x105, 207 => 0x105 },
	'temperature' => { 218 => 'Temperature' },
	'tempo' => { 235 => 'tempo' },
	'termsandconditionstext' => { 226 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 226 => 'TermsAndConditionsURL' },
	'textstamp' => { 178 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 68 => 0x107 },
	'thumbnailfilename' => { 58 => 0x817 },
	'thumbnailformat' => { 233 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 82 => 0xfa55, 233 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 58 => 0x2008, 66 => 'ThumbnailImage', 70 => 0x3, 105 => 'data', 167 => 0x100, 233 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 105 => '1Name' },
	'thumbnailimagesize' => { 105 => 'ImageSize' },
	'thumbnailimagetype' => { 105 => '0Type' },
	'thumbnailimagevalidarea' => { 32 => 0x13 },
	'thumbnaillength' => { 68 => 0x202 },
	'thumbnailoffset' => { 68 => 0x201 },
	'thumbnailwidth' => { 82 => 0xfa54, 233 => 'ThumbnailsWidth' },
	'ticker' => { 227 => 'ticker' },
	'tilelength' => { 68 => 0x143 },
	'tilewidth' => { 68 => 0x142 },
	'time' => { 79 => 0x401, 192 => 0x7 },
	'timecreated' => { 74 => 0x3c, 81 => 0x14, 89 => 0x10, 196 => 'TimeCreated' },
	'timeperiod' => { 227 => 'timePeriod' },
	'timerfunctionbutton' => { 143 => '734.2' },
	'timerlength' => { 45 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 235 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 235 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 235 => 'timeScaleParamsQuality' },
	'timesent' => { 75 => 0x50 },
	'timesignature' => { 235 => 'timeSignature' },
	'timesincepoweron' => { 178 => 0x29 },
	'timestamp' => { 5 => 0x45e, 11 => 0x11c, 173 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 147 => 0x0 },
	'timezonecode' => { 61 => 0x1 },
	'timezoneinfo' => { 61 => 0x2 },
	'timezoneoffset' => { 68 => 0x882a },
	'tint' => { 218 => 'Tint' },
	'title' => { 95 => 'Title', 171 => 'Title', 173 => 'Title', 200 => 'Title', 219 => 'title', 224 => 'Title' },
	'tonecomp' => { 134 => 0x81 },
	'tonecurve' => { 38 => 0x1, 192 => 0x402, 218 => 'ToneCurve' },
	'tonecurveactive' => { 62 => 0x110 },
	'tonecurvefilename' => { 79 => 0x1391 },
	'tonecurvename' => { 218 => 'ToneCurveName' },
	'tonecurveproperty' => { 62 => 0x3c },
	'tonecurves' => { 192 => 0x403 },
	'toningeffect' => { 28 => 0xf, 134 => 0xb3, 136 => 0x38 },
	'toningeffectmonochrome' => { 11 => 0x108 },
	'toningsaturation' => { 136 => 0x39 },
	'totalzoom' => { 81 => 0x62 },
	'tracknumber' => { 235 => 'trackNumber' },
	'tracksframerate' => { 235 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 235 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 235 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 235 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 235 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 235 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 235 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 235 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 235 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 235 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 235 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 235 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 235 => 'TracksMarkersType' },
	'trackstrackname' => { 235 => 'TracksTrackName' },
	'trackstracktype' => { 235 => 'TracksTrackType' },
	'trailersignature' => { 102 => 'zmie' },
	'transferfunction' => { 68 => 0x12d, 231 => 'TransferFunction' },
	'transform' => { 178 => [0x8012,0x59] },
	'transmissionreference' => { 225 => 'TransmissionReference' },
	'trapped' => { 171 => 'Trapped', 224 => 'Trapped' },
	'travelday' => { 178 => 0x36 },
	'ttl_da_adown' => { 188 => 0x5 },
	'ttl_da_aup' => { 188 => 0x4 },
	'ttl_da_bdown' => { 188 => 0x7 },
	'ttl_da_bup' => { 188 => 0x6 },
	'tvexposuretimesetting' => { 185 => 0x12 },
	'type' => { 219 => 'type' },
	'uniquecameramodel' => { 68 => 0xc614 },
	'uniquedocumentid' => { 74 => 0xbb },
	'uniqueobjectname' => { 75 => 0x64 },
	'unknownblock' => { 166 => 0x1103 },
	'unknowncompensation' => { 204 => 0xc },
	'unknownev' => { 79 => 0x1 },
	'unknownnumber' => { 58 => 0x180b },
	'unsharp1color' => { 160 => 0x13 },
	'unsharp1halowidth' => { 160 => 0x19 },
	'unsharp1intensity' => { 160 => 0x17 },
	'unsharp1threshold' => { 160 => 0x1b },
	'unsharp2color' => { 160 => 0x2e },
	'unsharp2halowidth' => { 160 => 0x34 },
	'unsharp2intensity' => { 160 => 0x32 },
	'unsharp2threshold' => { 160 => 0x36 },
	'unsharp3color' => { 160 => 0x49 },
	'unsharp3halowidth' => { 160 => 0x4f },
	'unsharp3intensity' => { 160 => 0x4d },
	'unsharp3threshold' => { 160 => 0x51 },
	'unsharp4color' => { 160 => 0x64 },
	'unsharp4halowidth' => { 160 => 0x6a },
	'unsharp4intensity' => { 160 => 0x68 },
	'unsharp4threshold' => { 160 => 0x6c },
	'unsharpcount' => { 160 => 0x0 },
	'unsharpmask' => { 155 => 0x76a43200 },
	'urgency' => { 74 => 0xa, 225 => 'Urgency' },
	'url' => { 95 => 'URL', 173 => 'URL', 198 => 0x40b, 227 => 'url' },
	'usablemeteringmodes' => { 45 => 0x10a },
	'usableshootingmodes' => { 45 => 0x109 },
	'usage' => { 228 => 'usage' },
	'usagefee' => { 229 => 'usageFee' },
	'usageterms' => { 239 => 'UsageTerms' },
	'usercomment' => { 58 => 0x805, 68 => 0x9286, 221 => 'UserComment' },
	'userdef1picturestyle' => { 11 => 0x10c },
	'userdef2picturestyle' => { 11 => 0x10e },
	'userdef3picturestyle' => { 11 => 0x110 },
	'userfields' => { 213 => 'UserFields' },
	'userprofile' => { 176 => 0x302, 179 => 0x3038 },
	'usmlenselectronicmf' => { 44 => 0x7, 45 => 0x501 },
	'utmeasting' => { 106 => 'Easting' },
	'utmmapdatum' => { 106 => 'Datum' },
	'utmnorthing' => { 106 => 'Northing' },
	'utmzone' => { 106 => 'Zone' },
	'uv-irfiltercorrection' => { 176 => 0x325 },
	'validbits' => { 166 => 0x611, 167 => 0x102c },
	'validpixeldepth' => { 170 => 0x611 },
	'variousmodes' => { 81 => 0x26 },
	'variousmodes2' => { 81 => 0x3a },
	'variprogram' => { 134 => 0xab },
	'version' => { 72 => 0x0, 200 => 'Version', 218 => 'Version' },
	'versionid' => { 236 => 'VersionID' },
	'versionidentifier' => { 227 => 'versionIdentifier' },
	'versionscomments' => { 236 => 'VersionsComments' },
	'versionseventaction' => { 236 => 'VersionsEventAction' },
	'versionseventchanged' => { 236 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 236 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 236 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 236 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 236 => 'VersionsEventWhen' },
	'versionsmodifier' => { 236 => 'VersionsModifier' },
	'versionsmodifydate' => { 236 => 'VersionsModifyDate' },
	'versionsversion' => { 236 => 'VersionsVersion' },
	'vfdisplayillumination' => { 45 => 0x510 },
	'vibrance' => { 218 => 'Vibrance' },
	'vibrationreduction' => { 140 => [0x75,0x82,0x1ae], 143 => '586.1', 144 => '590.2', 146 => 0x4 },
	'videoalphamode' => { 235 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 235 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 235 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 235 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 235 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 235 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 235 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 235 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 235 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 235 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 235 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 235 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 235 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 235 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 235 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 235 => 'videoColorSpace' },
	'videocompressor' => { 235 => 'videoCompressor' },
	'videofieldorder' => { 235 => 'videoFieldOrder' },
	'videoframerate' => { 235 => 'videoFrameRate' },
	'videoframesizeh' => { 235 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 235 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 235 => 'videoFrameSizeW' },
	'videomoddate' => { 235 => 'videoModDate' },
	'videopixelaspectratio' => { 235 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 235 => 'videoPixelDepth' },
	'viewfinderwarning' => { 118 => '12.4', 144 => '754.2' },
	'viewinfoduringexposure' => { 45 => 0x407 },
	'vignetteamount' => { 218 => 'VignetteAmount' },
	'vignettecontrol' => { 134 => 0x2a, 155 => 0x76a43205 },
	'vignettecontrolintensity' => { 155 => 0xac6bd5c0 },
	'vignettemidpoint' => { 218 => 'VignetteMidpoint' },
	'voicememo' => { 203 => 0x216 },
	'volume' => { 227 => 'volume' },
	'vr_0x66' => { 140 => 0x66 },
	'vrdoffset' => { 32 => 0xd0 },
	'wb_gbrglevels' => { 115 => 0x4 },
	'wb_glevel' => { 166 => 0x11f },
	'wb_glevel3000k' => { 166 => 0x113 },
	'wb_glevel3300k' => { 166 => 0x114 },
	'wb_glevel3600k' => { 166 => 0x115 },
	'wb_glevel3900k' => { 166 => 0x116 },
	'wb_glevel4000k' => { 166 => 0x117 },
	'wb_glevel4300k' => { 166 => 0x118 },
	'wb_glevel4500k' => { 166 => 0x119 },
	'wb_glevel4800k' => { 166 => 0x11a },
	'wb_glevel5300k' => { 166 => 0x11b },
	'wb_glevel6000k' => { 166 => 0x11c },
	'wb_glevel6600k' => { 166 => 0x11d },
	'wb_glevel7500k' => { 166 => 0x11e },
	'wb_grbglevels' => { 123 => 0x0 },
	'wb_rbgglevels' => { 120 => 0x0 },
	'wb_rblevels' => { 134 => 0xc, 166 => 0x100 },
	'wb_rblevels3000k' => { 166 => 0x102 },
	'wb_rblevels3300k' => { 166 => 0x103 },
	'wb_rblevels3600k' => { 166 => 0x104 },
	'wb_rblevels3900k' => { 166 => 0x105 },
	'wb_rblevels4000k' => { 166 => 0x106 },
	'wb_rblevels4300k' => { 166 => 0x107 },
	'wb_rblevels4500k' => { 166 => 0x108 },
	'wb_rblevels4800k' => { 166 => 0x109 },
	'wb_rblevels5300k' => { 166 => 0x10a },
	'wb_rblevels6000k' => { 166 => 0x10b },
	'wb_rblevels6600k' => { 166 => 0x10c },
	'wb_rblevels7500k' => { 166 => 0x10d },
	'wb_rblevelsauto' => { 170 => 0x110 },
	'wb_rblevelscloudy' => { 170 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 170 => 0x132 },
	'wb_rblevelscwb1' => { 166 => 0x10e },
	'wb_rblevelscwb2' => { 166 => 0x10f },
	'wb_rblevelscwb3' => { 166 => 0x110 },
	'wb_rblevelscwb4' => { 166 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 170 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 170 => 0x131 },
	'wb_rblevelseveningsunlight' => { 170 => 0x124 },
	'wb_rblevelsfineweather' => { 170 => 0x122 },
	'wb_rblevelsshade' => { 170 => 0x120 },
	'wb_rblevelstungsten' => { 170 => 0x123 },
	'wb_rblevelsused' => { 170 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 170 => 0x133 },
	'wb_rgbglevels' => { 122 => 0x0 },
	'wb_rgblevels' => { 177 => 0xd, 179 => 0x3036 },
	'wb_rggblevels' => { 115 => 0x4, 121 => 0x0 },
	'wb_rggblevelsasshot' => { 20 => 0x19, 21 => 0x22, 22 => 0x3f, 23 => 0x3f, 24 => 0x47 },
	'wb_rggblevelsauto' => { 19 => 0x0, 20 => 0x1e, 21 => 0x18, 22 => 0x44, 23 => 0x44, 24 => 0x4c },
	'wb_rggblevelscloudy' => { 19 => 0xc, 20 => 0x2d, 21 => 0x31, 22 => 0x58, 23 => 0x5d, 24 => 0x65, 192 => 0x20f },
	'wb_rggblevelscustom' => { 19 => 0x1c, 22 => 0x80 },
	'wb_rggblevelscustom1' => { 20 => 0x41 },
	'wb_rggblevelscustom2' => { 20 => 0x46 },
	'wb_rggblevelsdaylight' => { 19 => 0x4, 20 => 0x23, 21 => 0x27, 22 => 0x4e, 23 => 0x53, 24 => 0x5b, 192 => 0x20d },
	'wb_rggblevelsflash' => { 19 => 0x18, 20 => 0x3c, 21 => 0x45, 22 => 0x6c, 23 => 0x71, 24 => 0x79, 192 => 0x214 },
	'wb_rggblevelsfluorescent' => { 19 => 0x14, 20 => 0x37, 21 => 0x3b, 22 => 0x62, 23 => 0x67, 24 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 192 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 192 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 192 => 0x213 },
	'wb_rggblevelskelvin' => { 19 => 0x20, 21 => 0x40, 22 => 0x67, 23 => 0x6c, 24 => 0x74 },
	'wb_rggblevelsmeasured' => { 22 => 0x49, 23 => 0x49, 24 => 0x51 },
	'wb_rggblevelspc1' => { 21 => 0x90, 22 => 0x71 },
	'wb_rggblevelspc2' => { 21 => 0x95, 22 => 0x76 },
	'wb_rggblevelspc3' => { 21 => 0x9a, 22 => 0x7b },
	'wb_rggblevelsshade' => { 19 => 0x8, 20 => 0x28, 21 => 0x2c, 22 => 0x53, 23 => 0x58, 24 => 0x60, 192 => 0x20e },
	'wb_rggblevelstungsten' => { 19 => 0x10, 20 => 0x32, 21 => 0x36, 22 => 0x5d, 23 => 0x62, 24 => 0x6a, 192 => 0x210 },
	'wb_rggblevelsunknown' => { 21 => 0x1d, 23 => 0x4e, 24 => 0x56 },
	'wb_rggblevelsunknown10' => { 21 => 0x72, 23 => 0x9e, 24 => 0xa6 },
	'wb_rggblevelsunknown11' => { 21 => 0x77, 23 => 0xa3, 24 => 0xab },
	'wb_rggblevelsunknown12' => { 21 => 0x7c, 24 => 0xb0 },
	'wb_rggblevelsunknown13' => { 21 => 0x81, 24 => 0xb5 },
	'wb_rggblevelsunknown14' => { 21 => 0x86 },
	'wb_rggblevelsunknown15' => { 21 => 0x8b },
	'wb_rggblevelsunknown16' => { 21 => 0x9f },
	'wb_rggblevelsunknown2' => { 21 => 0x4a, 23 => 0x76, 24 => 0x7e },
	'wb_rggblevelsunknown3' => { 21 => 0x4f, 23 => 0x7b, 24 => 0x83 },
	'wb_rggblevelsunknown4' => { 21 => 0x54, 23 => 0x80, 24 => 0x88 },
	'wb_rggblevelsunknown5' => { 21 => 0x59, 23 => 0x85, 24 => 0x8d },
	'wb_rggblevelsunknown6' => { 21 => 0x5e, 23 => 0x8a, 24 => 0x92 },
	'wb_rggblevelsunknown7' => { 21 => 0x63, 23 => 0x8f, 24 => 0x97 },
	'wb_rggblevelsunknown8' => { 21 => 0x68, 23 => 0x94, 24 => 0x9c },
	'wb_rggblevelsunknown9' => { 21 => 0x6d, 23 => 0x99, 24 => 0xa1 },
	'wbadjbluebalance' => { 161 => 0x8 },
	'wbadjcolortemp' => { 62 => 0x1a },
	'wbadjlighting' => { 161 => 0x15 },
	'wbadjlightingsubtype' => { 161 => 0x14 },
	'wbadjmode' => { 161 => 0x10 },
	'wbadjredbalance' => { 161 => 0x0 },
	'wbadjrgblevels' => { 62 => 0x8 },
	'wbadjtemperature' => { 161 => 0x18 },
	'wbadjtint' => { 161 => 0x25 },
	'wbadjustab' => { 178 => 0x46 },
	'wbadjustgm' => { 178 => 0x47 },
	'wbbluelevel' => { 176 => 0x324, 178 => 0x8006, 180 => 0x26 },
	'wbbracketmode' => { 28 => 0x9 },
	'wbbracketvalueab' => { 28 => 0xc },
	'wbbracketvaluegm' => { 28 => 0xd },
	'wbfinetuneactive' => { 62 => 0x24 },
	'wbfinetunesaturation' => { 62 => 0x28 },
	'wbfinetunetone' => { 62 => 0x2c },
	'wbgreenlevel' => { 176 => 0x323, 178 => 0x8005, 180 => 0x25 },
	'wbmediaimagesizesetting' => { 45 => 0x708 },
	'wbmode' => { 114 => 0x4, 167 => 0x1015 },
	'wbredlevel' => { 176 => 0x322, 178 => 0x8004, 180 => 0x24 },
	'wbscale' => { 115 => 0x0 },
	'wbshiftab' => { 38 => 0xc, 186 => 0x10 },
	'wbshiftgm' => { 38 => 0xd },
	'wbshiftmg' => { 186 => 0x11 },
	'webstatement' => { 239 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 7 => 0x6f, 8 => 0x6f, 9 => 0x73, 10 => 0x6f, 11 => 0x54, 12 => 0x6f, 14 => 0x53, 38 => 0x8, 40 => 0x7, 64 => 0x7, 65 => [0x19,0x2012], 68 => [0xa403,0xfe4e], 72 => 0x1002, 79 => 0x3fc, 80 => 0xfa0d, 81 => 0x40, 108 => 0x3, 109 => 0xe, 110 => 0x4, 111 => 0xb, 112 => 0x115, 134 => 0x5, 145 => 0x7, 176 => 0x304, 178 => 0x3, 192 => 0x19, 194 => 0x7, 201 => 0x26, 204 => [0x3c,0x7], 207 => [0x115,0xb054], 218 => 'WhiteBalance', 221 => 'WhiteBalance' },
	'whitebalance2' => { 162 => 0x500 },
	'whitebalanceadj' => { 62 => 0x18, 155 => 0x76a43204 },
	'whitebalancebias' => { 65 => 0x2011, 167 => 0x304, 178 => 0x23 },
	'whitebalanceblue' => { 38 => 0x7 },
	'whitebalancebracket' => { 162 => 0x502, 167 => 0x303 },
	'whitebalancebracketing' => { 111 => 0x22 },
	'whitebalancecomp' => { 170 => 0x1001 },
	'whitebalancefinetune' => { 72 => 0x100a, 111 => 0x38, 112 => 0x112, 134 => 0xb, 205 => 0x6, 207 => 0x112 },
	'whitebalancemode' => { 192 => 0x1a },
	'whitebalancered' => { 38 => 0x6 },
	'whitebalanceset' => { 185 => 0xa },
	'whitebalancesetting' => { 111 => 0x23 },
	'whitebalancetemperature' => { 162 => 0x501 },
	'whiteboard' => { 167 => 0x301 },
	'whitelevel' => { 68 => 0xc61d },
	'whitepoint' => { 68 => 0x13e, 192 => 0x201, 231 => 'WhitePoint' },
	'widefocuszone' => { 108 => 0x2f },
	'widerange' => { 203 => 0x20f },
	'wordcount' => { 227 => 'wordCount' },
	'workcolorspace' => { 62 => 0x270 },
	'worldtimelocation' => { 178 => 0x3a, 192 => 0x22 },
	'writer-editor' => { 74 => 0x7a },
	'x3filllight' => { 204 => 0x12 },
	'xmp' => { 69 => 'XMP' },
	'xmptoolkit' => { 232 => 'xmptk' },
	'xpauthor' => { 68 => 0x9c9d },
	'xpcomment' => { 68 => 0x9c9c },
	'xpkeywords' => { 68 => 0x9c9e },
	'xposition' => { 68 => 0x11e },
	'xpsubject' => { 68 => 0x9c9f },
	'xptitle' => { 68 => 0x9c9b },
	'xresolution' => { 68 => 0x11a, 77 => 0x3, 199 => 0x0, 231 => 'XResolution' },
	'xyresolution' => { 71 => 0x3 },
	'ycbcrcoefficients' => { 68 => 0x211, 231 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 68 => 0x213, 231 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 68 => 0x212, 231 => 'YCbCrSubSampling' },
	'yearcreated' => { 81 => 0x10, 89 => 0xc },
	'yposition' => { 68 => 0x11f },
	'yresolution' => { 68 => 0x11b, 77 => 0x5, 199 => 0x4, 231 => 'YResolution' },
	'zonematching' => { 111 => 0x14, 112 => 0x10a, 114 => 0x3a, 207 => 0xb024 },
	'zonematchingon' => { 110 => 0x75 },
	'zonematchingvalue' => { 205 => 0x1f },
	'zoomsourcewidth' => { 18 => 0x24 },
	'zoomstepcount' => { 165 => 0x300, 167 => 0x100d },
	'zoomtargetwidth' => { 18 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationdata' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsd300' => 1,
	'camerasettingsifd' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'fontsize' => 1,
	'fontweight' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikon_0x00b9' => 1,
	'nikon_avitags_0x000d' => 1,
	'nikon_avitags_0x000e' => 1,
	'nikon_avitags_0x0015' => 1,
	'nikon_avitags_0x0017' => 1,
	'nikon_avitags_0x0019' => 1,
	'nikon_avitags_0x001c' => 1,
	'nikon_avitags_0x801a' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikondata' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureinfo' => 1,
	'picturemimetype' => 1,
	'picturetype' => 1,
	'pieceinfo' => 1,
	'pitchangle' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollangle' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'synchronizedlyrictext' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2009, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
