
   -- Resources are exporting in the gallery folder during preview
   local theRoot = "."
   
   -- When publishing via Publish Services, we find them in the parent
   if mode == "publishAsSubGallery" and not pt_publishInsideParent then theRoot = rootPrefix end

   -- Helper functions

   local replaceMap = {
      [ ' ' ] = '%20',
   }
   
   if WIN_ENV then
      replaceMap[ '\\' ] = '/'
   end
   
   local filePathToURIPath = function(filePath)
      local subs = string.gsub(filePath, '[\\ ]', function(x) return replaceMap[x] end )
      return subs
   end
   
   -- Initialise menu item links

   local function adjustLink(str)
   
      if str == "[Home Page]" then
         if model.nonCSS.startPage == "home" or mode ~= "publishAsSubGallery" then
            return theRoot.."/index.html"
         else
            return theRoot.."/home.html"
         end
      elseif str == "[Galleries Page]" then
         if model.nonCSS.startPage == "galleries" and mode == "publishAsSubGallery" then
            return theRoot.."/index.html"
         else
            return theRoot.."/galleries.html"
         end
      elseif str == "[Contact Page]" then
         return theRoot.."/contact.html"
      elseif str == "[Misc Page 1]" then
         return theRoot.."/misc1.html"
      elseif str == "[Misc Page 2]" then
         return theRoot.."/misc2.html"
      elseif str == "[Misc Page 3]" then
         return theRoot.."/misc3.html"
      end
   
      return str
      
   end
   
   local menuItems = { "one", "two", "three", "four", "five", "six" }

   menu = {}
   for _, mi in pairs(menuItems) do
      menu[mi] = { url = adjustLink(model.nonCSS.menuitems[mi].url) }
   end

   brandingLink = adjustLink(model.nonCSS.brandingImage.link)

   -- Image resources

   local styles = {}
   if model.nonCSS.backgroundImage.enable and #model.nonCSS.backgroundImage.localFileName  > 0 then
   
      local bgURI
      if mode == "publishAsSubGallery" then
         bgURI = theRoot .. "/" .. imageResources["bgimage"]
      else
         bgURI = "file:///" .. filePathToURIPath(model.nonCSS.backgroundImage.localFileName) 
      end
      
      styles["body"] = {}
      styles["body"]["background-image"] = "url(" .. bgURI .. ")"
      
   end

   if model.nonCSS.menuBackgroundImage.enable and #model.nonCSS.menuBackgroundImage.localFileName  > 0 then
   
      local bgURI
      if mode == "publishAsSubGallery" then
         bgURI = theRoot .. "/" .. imageResources["bgmenuimage"]
      else
         bgURI = "file:///" .. filePathToURIPath(model.nonCSS.menuBackgroundImage.localFileName) 
      end
      
      styles["#menu"] = {}
      styles["#menu"]["background-image"] = "url(" .. bgURI .. ")"
      
   end

   local brandingImageURI
   if model.nonCSS.brandingImage.enable and #model.nonCSS.brandingImage.localFileName  > 0 then
   
      if mode == "publishAsSubGallery" then
         brandingImageURI = theRoot .. "/" .. imageResources["brandingimage"]
      else
         brandingImageURI = "file:///" .. filePathToURIPath(model.nonCSS.brandingImage.localFileName) 
      end
      
   end

